from __future__ import absolute_import

from .. import api
from ..types import resource as ctr


class Api(api.Api):
    pass


class MDSFileMeta(Api.Schema):
    key = api.String("MDS key")
    type = api.Enum("File type", required=True, values=ctr.FileType)
    path = api.String("Relative path", required=True)
    executable = api.Boolean("Executable bit", default=False)
    symlink = api.String("Symlink target")
    size = api.Integer("File size, in bytes")
    md5 = api.String("MD5 sum")
    sha1_blocks = api.Array(api.String, "SHA1 hashes for the file blocks")
    offset = api.Integer("Header offset in tar archive")
    mime = api.String("MIME type for file")
