from __future__ import absolute_import, print_function

import socket
import logging

logger = logging.getLogger(__name__)


def is_port_free(port, host='localhost', protocol='tcp'):
    """
    Check port availability

    :param port: port number (string or int)
    :param host: hostname
    :param protocol: 'tcp' or 'udp'
    """

    logger.info('Check port %s for host %s for %s protocol', port, host, protocol)
    try:
        if protocol == 'tcp':
            sock_type = socket.SOCK_STREAM
        elif protocol == 'udp':
            sock_type = socket.SOCK_DGRAM
        else:
            raise ValueError("Not supported protocol {}".format(protocol))
        sock = socket.socket(socket.AF_INET, sock_type)
        sock.connect((host, int(port)))
        sock.close()
        return False
    except socket.error:
        pass
    return True


def lock_on_port(port):
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.bind(('127.0.0.1', port))
    return sock
