from __future__ import absolute_import, print_function

import random
import string


def random_string(length=8, characters=string.ascii_uppercase + string.digits):
    return "".join(random.choice(characters) for _ in range(length))


_ADJECTIVES = [
    "adorable", "alive", "ancient", "angry", "beautiful", "better", "big",
    "bitter", "brave", "breeze", "broken", "bumpy", "calm", "careful",
    "chilly", "chubby", "clean", "clever", "clumsy", "cold", "colossal",
    "cooing", "cool", "creepy", "crooked", "crooked", "cuddly", "curly",
    "curved", "delicious", "delightful", "dirty", "dusty", "eager",
    "early", "easy", "elegant", "embarrassed", "faint", "faithful", "famous",
    "fancy", "fast", "fat", "fierce", "filthy", "flaky", "flat", "fluffy",
    "freezing", "fresh", "gentle", "gifted", "gigantic", "glamorous",
    "greasy", "great", "grumpy", "handsome", "happy", "helpful", "helpless",
    "hissing", "hollow", "hot", "huge", "icy", "immense", "important",
    "jealous", "jolly", "juicy", "kind", "large", "lazy", "little", "lively",
    "long", "loose", "loud", "magnificent", "massive", "melodic", "miniature",
    "modern", "mushy", "mysterious", "narrow", "nervous", "nice", "noisy",
    "nutritious", "obedient", "obnoxious", "odd", "old", "orange", "panicky",
    "plain", "powerful", "prickly", "proud", "puny", "purple",
    "quick", "quiet", "rapid", "relieved", "rich", "round", "salty", "scary",
    "scrawny", "shallow", "short", "short", "shy", "silly", "skinny",
    "sleepy", "slow", "small", "sparkling", "square", "steep", "sticky",
    "strong", "sweet", "swift", "tall", "tart", "tasteless", "teeny",
    "tender", "thankful", "thoughtless", "thundering", "tiny", "uneven",
    "uninterested", "unsightly", "uptight", "vast", "victorious",
    "whispering", "witty", "wooden", "worried", "yellow", "young", "zealous",
]

_ANIMALS = [
    "aardvark", "albatross", "alligator", "alpaca", "ant", "anteater",
    "antelope", "ape", "aripinen", "armadillo", "baboon", "badger",
    "barracuda", "bat", "bear", "beaver", "bee", "bird", "bison", "boar",
    "buffalo", "butterfly", "camel", "cat", "caterpillar", "cattle",
    "cheetah", "chicken", "chimpanzee", "chinchilla", "cobra", "cockroach",
    "coyote", "crab", "crane", "crocodile", "crow", "deer", "dinosaur",
    "dog", "dogfish", "dolphin", "donkey", "dove", "dragonfly", "duck",
    "dugong", "dunlin", "eagle", "echidna", "eel", "eland", "elephant",
    "elk", "emu", "falcon", "ferret", "finch", "fish", "flamingo", "fly",
    "fox", "frog", "gaur", "gazelle", "gerbil", "giraffe", "gnat",
    "gnu", "goat", "goldfinch", "goosander", "goose", "gorilla", "goshawk",
    "grasshopper", "grouse", "guanaco", "guinea", "gull", "guschin",
    "hamster", "hare", "hawk", "hedgehog", "heron", "herring", "hippo",
    "hornet", "horse", "hummingbird", "hyena", "impala", "jackal", "jaguar",
    "jay", "jellyfish", "kangaroo", "koala", "korum", "kudu", "knight",
    "lapwing", "lark", "lemur", "leopard", "lion", "llama", "lobster",
    "locust", "loris", "louse", "lyrebird", "magpie", "mallard", "mammoth",
    "mole", "mongoose", "monkey", "moose", "mosquito", "mouse", "narwhal",
    "nightingale", "octopus", "opossum", "ostrich", "otter", "owl", "oyster",
    "panda", "panther", "parrot", "pelican", "penguin", "pheasant", "pig",
    "pigeon", "pony", "porcupine", "rabbit", "raccoon", "ram", "rat", "raven",
    "reindeer", "rhinoceros", "rvetrov", "ryabinin", "salamander", "salmon",
    "sardine", "seahorse", "seal", "shark", "sheep", "shrew", "skunk", "sloth",
    "snail", "snake", "spider", "squid", "squirrel", "starling", "swan",
    "tapir", "termite", "tiger", "toad", "tshatrov", "turkey", "turtle",
    "wallaby", "walrus", "wasp", "weasel", "werat", "whale", "white", "wolf",
    "wolverine", "wombat", "wren", "yak", "yetty", "zebra",
]


def get_random_name():
    return "{}-{}".format(random.choice(_ADJECTIVES), random.choice(_ANIMALS))
