from __future__ import absolute_import, unicode_literals

from .. import enum


class View(enum.Enum):
    DEFAULT = "DEFAULT"
    EXECUTION_REPORT = "EXECUTION"
    RELEASE_REPORT = "RELEASE"


class Transport(enum.Enum):
    enum.Enum.lower_case()

    EMAIL = None
    TELEGRAM = None
    Q = None
    JUGGLER = None


class JugglerCheck(enum.Enum):
    enum.Enum.lower_case()

    TASK_STATUS_CHANGED = None
    SCHEDULER_STATUS_CHANGED = None
    MDS_QUOTA_EXCEEDED = None


class JugglerStatus(enum.Enum):
    OK = None
    WARN = None
    CRIT = None


class Type(enum.Enum):
    TEXT = "plain"
    HTML = "html"


class Charset(enum.Enum):
    ASCI = 'us-ascii'
    UTF = 'utf-8'


class Severity(enum.Enum):
    INFO = None
    WARNING = None
    CRITICAL = None
