from __future__ import absolute_import, unicode_literals

from .. import enum


TASK_LOG_RESOURCE_TYPE = "TASK_LOGS"
DEFAULT_MDS_NAMESPACE = "sandbox"
BUCKETS_PREFIX = "sandbox-"
DEFAULT_S3_BUCKET = BUCKETS_PREFIX + "tmp"
MONGO_BACKUP_S3_BUCKET = BUCKETS_PREFIX + "backup"
SPECIAL_BUCKETS = (DEFAULT_S3_BUCKET, MONGO_BACKUP_S3_BUCKET)
WAREHOUSE_BUCKET = "warehouse-sandbox"

EMPTY_FILE_MD5 = "d41d8cd98f00b204e9800998ecf8427e"


class State(enum.Enum):
    """ Resource states. """

    NOT_READY = None
    READY = None
    BROKEN = None
    DELETED = None


class HostState(enum.Enum):
    """ Resource host states. """

    OK = None
    MARK_TO_DELETE = None


class LinkType(enum.Enum):
    """ Resource's data link type. """

    HTTP = None
    RSYNC = None


class ServiceAttributes(enum.Enum):
    """ Resource attributes, which are used by Sandbox itself. """

    TTL = "ttl"
    RELEASED = "released"
    BACKUP_TASK = "backup_task"
    TTL_ON_RELEASE = "ttl_on_release"  # TTL to set to resource after its release


class BinaryAttributes(enum.Enum):
    """ Binary tasks' resource attributes. """

    REVISION = "commit_revision"
    BINARY_AGE = "binary_age"
    BINARY_HASH = "binary_hash"
    TASKBOX_ENABLED = "taskbox_enabled"


class RestartPolicy(enum.Enum):
    """ The enumeration defines possible actions for task's resources on task restart. """

    DELETE = None  # Delete resource
    RESET = None  # Switch resource to "NOT_READY" state
    IGNORE = None  # Do not change resource's state


class SandboxTasksResources(enum.Enum):
    """ Types of sandbox tasks resources """

    SANDBOX_TASKS_IMAGE = None
    SANDBOX_TASKS_ARCHIVE = None


class FileType(enum.Enum):
    """ File types, used for saving MDS metadata """
    enum.Enum.lower_case()

    FILE = None
    DIR = None
    SYMLINK = None
    TOUCH = None
    ERROR = None
    TARDIR = None


def relpath(rid):
    """
    Determines resource's relative directory path name for the common data directory by given resource identifier.

    :param rid: resource ID
    :return: Array of sub-directories names.
    """
    if not rid:
        raise ValueError("{!r} is not valid resource ID".format(rid))
    rid = str(rid)
    return rid[-4:-2] or "00", rid[-2:] or "00", rid
