from __future__ import absolute_import, unicode_literals

from .. import enum


class Status(enum.Enum):
    """ Possible scheduler statuses. """

    STOPPED = None
    WATCHING = None
    WAITING = None
    FAILURE = None
    DELETED = None


class Retry(enum.Enum):
    """ Schedulers' retry on failed tasks policies """

    # Do not retry failed tasks
    NO = "no"
    # Retry failed tasks after time interval
    INTERVAL = "interval"
    # Stop scheduler in case of failed tasks
    FAILURE = "failure"


class StartMode(enum.Enum):
    """ First scheduled task start time """

    # Start task immediately
    IMMEDIATELY = "immediately"
    # Start in scheduled time
    SET = "set"


class Repetition(enum.Enum):
    """ Scheduling policy """

    # Do not repeat
    NO = "no"
    # Run tasks periodically
    INTERVAL = "interval"
    # Run tasks in given days of week
    WEEKLY = "weekly"


class RunType(enum.Enum):
    """ Run type """

    # Run task on schedule
    SCHEDULED = None
    # Run task manually
    MANUAL = None
