from __future__ import absolute_import, unicode_literals

import collections

from . import task as ctt
from .. import enum


#: User name for anonymous login.
ANONYMOUS_LOGIN = "guest"

#: Sandbox service group.
SERVICE_GROUP = "SANDBOX"

#: Priority limits type.
PriorityLimits_t = collections.namedtuple("PriorityLimits", ("ui", "api"))

_OtherGroupType = collections.namedtuple("OtherGroup", ("name", "priority_limits"))
#: Virtual group name for those users, who don't belong to any group.
OTHERS_GROUP = _OtherGroupType(
    "OTHER",
    PriorityLimits_t(
        ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.LOW),
        ctt.Priority(ctt.Priority.Class.BACKGROUND, ctt.Priority.Subclass.LOW),
    )
)

#: Maximum allowed priorities for regular users.
DEFAULT_PRIORITY_LIMITS = PriorityLimits_t(
    ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.HIGH),
    ctt.Priority(ctt.Priority.Class.SERVICE, ctt.Priority.Subclass.HIGH),
)

#: Maximum allowed priorities for superuser.
SU_PRIORITY_LIMITS = PriorityLimits_t(
    ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.HIGH),
    ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.HIGH),
)


class Restriction(enum.Enum):
    ANY = None
    AUTHENTICATED = None
    ADMIN = None
    TASK = None
    STATISTICS = None
    TVM_SERVICE = None
    SESSION_MAKER = None
    EXTERNAL_SESSION = None


class TokenSource(enum.Enum):
    """ OAuth token source enumeration. """

    class Group(enum.GroupEnum):
        EXTERNAL = None

    PASSPORT = None
    SSH_KEY = None
    CLIENT = None
    EXTERNAL_SESSION = None


class GroupSource(enum.Enum):
    """ Source for syncing content of the group """

    STAFF = None
    RB = None
    ABC = None
    USER = None


class Rights(enum.Enum):
    """ User's rights """
    enum.Enum.lower_case()

    READ = None
    WRITE = None

    @classmethod
    def get(cls, write_access):
        return cls.WRITE if write_access else cls.READ


class Role(enum.Enum):
    """ User's role """
    enum.Enum.lower_case()

    ANONYMOUS = None
    REGULAR = None
    TRUSTED = None
    ADMINISTRATOR = None
    STATISTICS = None
    # Capability to [re]start tasks on behalf of any user
    TASKS_SUDO = None
    # Capability to create and manage tasks sessions
    SESSION_MAKER = None
