from __future__ import absolute_import, unicode_literals

from sandbox.common import config

from six.moves.urllib import parse as urlparse


def server_url(settings=None):
    if not settings:
        settings = config.Registry()
    addr = settings.server.web.address
    return str(
        "http://{host}:{port}".format(host=addr.host, port=settings.server.api.port)
        if addr.show_port else
        "https://{}".format(addr.host)
    )


def staff_url(settings=None):
    if not settings:
        settings = config.Registry()
    return settings.common.staff.url


def get_task_link(task_id, settings=None):
    return str(urlparse.urljoin(server_url(settings), "task/{}".format(task_id)))


def get_resource_link(resource_id, settings=None):
    return str(urlparse.urljoin(server_url(settings), "resource/{}".format(resource_id)))


def get_scheduler_link(scheduler_id, settings=None):
    return str(urlparse.urljoin(server_url(settings), "scheduler/{}".format(scheduler_id)))


def get_group_link(group_name, settings=None):
    return str(urlparse.urljoin(server_url(settings), "admin/groups/{}".format(group_name)))


def get_user_link(user, settings=None):
    return str(urlparse.urljoin(staff_url(settings), user))


def execution_dir_link(task_id, settings=None):
    """
    Obtain URL to a task's execution directory for a quick view (works with all Sandbox installation types)

    :param task_id: target task identifier
    :param settings: Sandbox settings object
    :type settings: sandbox.common.config.Registry
    :return: task execution directory URL
    """

    from ..types import task as ctt
    if not settings:
        settings = config.Registry()

    fs_settings = settings.client.fileserver
    if fs_settings.proxy.host:
        return str("https://{}/task/{}".format(fs_settings.proxy.host, task_id))

    # running on local Sandbox; there's no proxy but a fileserver
    return str("http://{}:{}/{}".format(
        settings.server.web.address.host, fs_settings.port,
        "/".join(ctt.relpath(task_id))
    ))
