from __future__ import print_function
from __future__ import absolute_import

import hashlib

# noinspection PyUnresolvedReferences
from ..encoding import force_unicode, force_unicode_safe, escape  # noqa

# noinspection PyUnresolvedReferences
from ..enum import Enum, GroupEnum  # noqa

# noinspection PyUnresolvedReferences
from ..format import (  # noqa
    print_table, str2size, size2str, dt2str, utcdt2iso, td2str, format_exception, ident, obfuscate_token,
    brace_expansion
)

# noinspection PyUnresolvedReferences
from ..itertools import (  # noqa
    progressive_yielder, progressive_waiter, chain, as_list, grouper, grouper_longest, chunker, merge_dicts
)

# noinspection PyUnresolvedReferences
from ..patterns import (  # noqa
    classproperty, singleton_classproperty, is_classproperty, SingletonMeta, ThreadSafeSingletonMeta, ttl_cache,
    singleton, namedlist, Api, singleton_property, ThreadLocalMeta
)

# noinspection PyUnresolvedReferences
from ..hardware import HostInfo  # noqa

# noinspection PyUnresolvedReferences
from ..urls import server_url, get_task_link, get_resource_link, get_scheduler_link, execution_dir_link  # noqa

# noinspection PyUnresolvedReferences
from ..context import Timer, call_with, disabled_gc, LoggerLevelChanger, NullContextmanager  # noqa

# noinspection PyUnresolvedReferences
from ..fs import to_path, read_settings_value_from_file, gzip_file, cleanup  # noqa

# noinspection PyUnresolvedReferences
from ..math import percentile, progress  # noqa

# noinspection PyUnresolvedReferences
from ..random import random_string  # noqa

# noinspection PyUnresolvedReferences
from ..threading import FLock, RFLock  # noqa

# noinspection PyUnresolvedReferences
from ..hash import md5sum  # noqa

# noinspection PyUnresolvedReferences
from ..network import is_port_free, lock_on_port  # noqa

# noinspection PyUnresolvedReferences
from ..lazy import LazyLoader  # noqa

# noinspection PyUnresolvedReferences
from ..system import DiskSpace, CPU, get_sysparams, get_disk_space  # noqa

# noinspection PyUnresolvedReferences
from ..data import force_int  # noqa


def checker_fetcher(url, md5=None, chunk_size=0x7FFF, **kwargs):
    """
    Fetch a data located at the given URL and check its content size and MD5 checksum if they're provided.
    Data is yielded by chunks.

    :param url: URL to fetch data from
    :param md5: MD5 checksum of the data
    :param chunk_size: size of a single chunk of data
    :param kwargs: addditional keyword arguments for `requests.get` method
    """

    import requests

    r = requests.get(url, stream=True, **kwargs)
    r.raise_for_status()
    try:
        size = int(r.headers["content-length"])
    except (TypeError, ValueError, KeyError):
        size = None
    actual_size = 0
    actual_md5 = hashlib.md5()
    for chunk in r.iter_content(chunk_size):
        actual_size += len(chunk)
        actual_md5.update(chunk)
        yield chunk

    if size and actual_size != size:
        raise ValueError("Data size {} mismatch: expected {}".format(actual_size, size))
    if md5 and md5 != actual_md5.hexdigest():
        raise ValueError("MD5 checksum {!r} mismatch: expected {!r}".format(actual_md5.hexdigest(), md5))
