#! /usr/bin/env python
# -*- coding: utf-8 -*-
import os
import re
import sys
import json
import datetime as dt
import subprocess as sp


def main():
    try:
        while True:
            line = sys.stdin.readline().rstrip()
            if len(line) == 0:
                break

            message = json.loads(line)
            re_search = re.search('"seqNo":(\\d+)', line)
            if re_search:
                message["type"] = "message"
                message["seqNo"] = int(re_search.group(1))
                message["timestamp"] = dt.datetime.utcnow().isoformat()
                metrics = [
                    metric_node_count(),
                    metric_storage_space()
                ]
                if metrics is None:
                    message["type"] = "reject_message"
                message["payload"] = json.dumps({"metrics": metrics})
            else:
                message["type"] = "reject_message"

            json.dump(message, sys.stdout)
            sys.stdout.write('\n')
            sys.stdout.flush()
    except Exception as ex:
        sys.stderr.write(str(ex))
        sys.stderr.flush()


def metric_node_count():
    try:
        node_count_str = sp.check_output(["echo srvr | nc localhost 2181 | grep 'Node count'"], shell=True)
        node_count_str = node_count_str.rstrip()
        prefix_len = len("Node count: ")
        node_count = int(node_count_str[prefix_len:])
        metric = {"labels": {"name": "node_count"}, "value": node_count}
        return metric
    except sp.CalledProcessError as ex:
        sys.stderr.write(str(ex))
        sys.stderr.flush()
        return None


def metric_storage_space():
    if not os.path.exists("/place/zookeeper/version-2/"):
        return None

    try:
        size_str = sp.check_output(["du -cs `ls /place/zookeeper/version-2/snapshot.*` | tail -1"], shell=True)
        size_str = size_str.rstrip()
        size_kb = int(size_str.split()[0])
        metric = {"labels": {"name": "storage_space_kb"}, "value": size_kb}
        return metric
    except sp.CalledProcessError as ex:
        sys.stderr.write(str(ex))
        sys.stderr.flush()
        return None


if __name__ == "__main__":
    main()
