import os
import shutil
import urllib2

from . import base


class Proxy(base.Base):
    __name__ = "proxy"

    _CONFIG = base.SandboxLauncher._CONFIG
    _CONFIG_PATCHES = base.SandboxLauncher._CONFIG_PATCHES

    _HTTP_PORT = 80

    @property
    def binary_path(self):
        return os.path.join(self.get_pack("proxy.tgz"), "proxy")

    @property
    def _ROTATE_LOGS(self):
        return self.logfiles()

    def user(self):
        return "root"

    @staticmethod
    def logfiles():
        """ List of logs sends to Elasticsearch """
        return [
            "/var/log/sandbox/proxy.log",
            "/var/log/sandbox/proxy-uwsgi.log"
        ]

    def balancer(self):
        return {
            "domain": "proxy",
            "location": "/",
            "port": self._HTTP_PORT
        }

    def packages(self):
        return ["proxy.tgz"]

    def ping(self):
        self._rotate_logs()
        try:
            urllib2.urlopen("http://localhost:{port}/http_check".format(port=self._HTTP_PORT), timeout=5)
            return True
        except Exception:
            return False

    def start(self):
        config_path = self.config_as_file()
        settings_path = os.path.join(self.get_pack("proxy.tgz"), "sandbox", "etc", "settings.yaml")
        if os.path.exists(settings_path):
            os.unlink(settings_path)
        shutil.copyfile(config_path, settings_path)
        self.change_permissions(settings_path, chmod=0o644, chown=self._service_user.name)

        self.change_permissions(self.binary_path, chmod=0o755)
        self.create(
            [self.binary_path],
            env={"SANDBOX_CONFIG": settings_path}
        )
