#!/skynet/python/bin/python -W ignore::UserWarning
# coding: utf-8

import os
import py
import sys
import argparse
import logging
import subprocess as sp

SANDBOX_DIR = reduce(lambda p, _: os.path.dirname(p), xrange(2), os.path.abspath(__file__))
sys.path = ["/skynet", os.path.dirname(SANDBOX_DIR), SANDBOX_DIR] + sys.path

from sandbox import common

from sandbox.devbox import config
from sandbox.devbox import bootstrap

logger = logging.getLogger("sandbox")
logger.propagate = False
h = logging.StreamHandler()
h.setFormatter(logging.Formatter("%(asctime)s %(levelname)-6s (%(module)s) %(message)s"))
logger.addHandler(h)


def _get_options():
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-c", "--config", type=str, action="store", default=None)
    parser.add_argument("-r", "--runtime", type=str, action="store", default=None)
    parser.add_argument("-v", "--verbose", action="store_true", default=False)
    parser.add_argument("--force-env-setup", action="store_true", default=False)
    args, unknown = parser.parse_known_args()
    return args


def main():
    if os.getuid() == 0:
        cz = common.console.AnsiColorizer()
        print(cz.red("Please don't run Sandbox under root privileges"))
        sys.exit(1)

    options = _get_options()
    logger.setLevel(logging.DEBUG if options.verbose else logging.INFO)
    runtime_data_path = config.get_runtime_data_path(options)
    devbox_path = py.path.local(sys.argv[0]).dirpath()
    sandbox_dir = devbox_path.dirname
    bootstrap_environment = bootstrap.BootEnvironment(runtime_data_path, sandbox_dir)
    bootstrap_environment.prepare_serviceapi()
    bootstrap_environment.prepare_preexecutor()
    bootstrap_environment.prepare_taskbox()
    bootstrap_environment.prepare_tvmtool()
    bootstrap_environment.prepare_py3_sources()
    env_exe = bootstrap_environment.prepare_virtual_environment(options.force_env_setup)
    exec_env = bootstrap_environment.get_exec_environment(sandbox_dir)
    prefix = [env_exe, str(devbox_path.join("ctl_impl.py"))]
    subcmd = sys.argv[1] if len(sys.argv) > 1 else ""
    if bootstrap_environment.should_check_for_updates and not any(subcmd.startswith(_) for _ in ("clean_", "stop_")):
        cz = common.console.AnsiColorizer()
        print(cz.yellow("Local resources are outdated, check for updates"))
        sp.check_call(prefix + ["check_updates"], env=exec_env)

    cmd = prefix + sys.argv[1:]
    if options.force_env_setup:
        cmd.remove("--force-env-setup")
    os.execve(env_exe, cmd, exec_env)


if __name__ == "__main__":
    main()
