import mongoengine as me
import sandbox.yasandbox.database.mapping.base as base


class ImportedTask(base.ConnectionSwitcherMixin, me.Document):
    """ Collection to store identifiers of tasks imported into local Sandbox """

    id = me.SequenceField(primary_key=True)
    original_id = me.IntField(required=True)
    local_id = me.IntField(required=True)


class ImportedResource(base.ConnectionSwitcherMixin, me.Document):
    """ Collection to store identifiers of resources imported into local Sandbox """

    id = me.SequenceField(primary_key=True)
    original_id = me.IntField(required=True)
    local_id = me.IntField(required=True)
