# Агенты

**Агент** (также известный как **клиент**) - машина, на которой исполняется Sandbox задача.
Большая часть агентов Sandbox – настоящие **железные сервера** ([MacMini](https://www.apple.com/mac-mini/) для MacOS).
Также существуют агенты, запускающиеся в виртуалках
QYP ([WINDOWS](https://sandbox.yandex-team.ru/clients/dc?tags=WINDOWS&limit=100500))
и YP ([PORTOD](https://sandbox.yandex-team.ru/clients/dc?tags=PORTOD&limit=100500)).

Агенты Sandbox расположены в нескольких локациях, что позволяет исполнять задачи даже во время учений и регламентных работ в датацентрах.


## Список агентов { #list }

Полный список агентов можно посмотреть на странице [Clients](https://sandbox.yandex-team.ru/clients) (меню **More > Clients**).
Данная страница имеет два режима отображения: **компактный** и **расширенный**. В компактном режиме каждый агент отображается в виде цветного квадратика:

![Компактный режим отображения агентов](img/agent-list-compact.png "Компактный режим отображения агентов")

В расширенном режиме для каждого агента отображаются подробные данные: число ядер, памяти, доступное дисковое пространство, теги и так далее:

![Расширенный режим отображения агентов](img/agent-list-extended.png "Расширенный режим отображения агентов")

При помощи элементов управления на странице можно фильтровать и группировать агенты по разным параметрам.

## Поддерживаемые платформы { #platforms }

В настоящее время поддерживаются следующие платформы:

* **MacOS**: Mojave (10.14), Catalina (10.15), Big Sur (11), Monterey (12)
* **Linux** (Ubuntu): Precise Pangolin (12.04), Trusty Tahr (14.04), Xenial Xerus (16.04), Bionic Beaver (18.04), Focal Fossa (20.04)
* **Windows**: свежая версия Windows 10 с поддержкой [Linux subsystem](https://en.wikipedia.org/wiki/Windows_Subsystem_for_Linux)

Если явно не указано в [требованиях](tasks.md#requirements), по-умолчанию задача всегда выполняется на Linux (таких агентов больше всего).

На обычных (`GENERIC`) sandbox агентах с MacOS поддерживаются только последние две версии системы в равных пропорциях.

Задачи, не указывающие тег `M1` явным образом, на хостах с `М1` исполняться не будут.

## Кеширование данных { #caching }

По-умолчанию задачи в Sandbox запускаются в чистом окружении.
Тем не менее существуют задачи, использующие большие объемы входных данных, например, полное содержимое единого репозитория.
Если такие задачи запускаются часто (например, проверка пулл-реквестов в единый репозиторий),
то для ускорения их работы становится выгодно хранить на агентах подготовленную копию данных, которая будет переиспользоваться между задачами.
Эта функциональность называется **кешированием данных**. В коде любой задачи можно объявить какие кешированные данные следует использовать.

## Количество задач, выполняющихся на агенте { #slots }

Исторически в Sandbox каждый агент выполнял **только одну задачу одновременно** (англ. *single slot* - одно место).
В те времена агенты редко имели больше 32 ядер, а большинство задач было связано с многопоточной сборкой C++ кода.
Современные сервера имеют гораздо больше ядер, а сам сервис используется, в том числе, для запуска легковесных однопоточных задач.
Подобные изменения привели к тому, что появились агенты, исполняющие **несколько задач одновременно**.
Такие агенты также называют **мультислотовыми** (англ. *multiple slots* - несколько мест), а выполнение задач на таких агентах - **"выполнением на мультислотах"**.

![Количество задач на агенте](img/agent-slots.png "Количество задач на агенте" =x300)

Для того чтобы задача попала на мультислотовый агент, должны выполняться следующие условия:

1. Задача должна требовать **не более 16 ядер**
2. Задача должна требовать **не более 64 Гбайт оперативной памяти**
3. Задача не должна требовать права администратора **root**
4. Задача не должна использовать **кешированные данные**

При выполнении этих условий задача будет запущена на мультислотах автоматически.
Все мультислотовые агенты используют только **SSD** диски, поэтому явно запрашивать наличие SSD не требуется.

Для удобства конфигурирования задач для мультислотовых клиентов имеются классы-настройки,
описанные в модуле [task_env](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/common/task_env/__init__.py?rev=r7953347#L5),
например `TinyRequirements` и `BuildRequirements`.
Небольшой анонс `task_env` с примерами был [в Этушке](https://clubs.at.yandex-team.ru/sandbox/3347).

## Теги { #tags }

В [предыдущем разделе](tasks.md#requirements) уже упоминалось, что в коде задачи можно указать требования к агенту:
количество ядер, памяти, тип диска, модель процессора и так далее.

1. Каждому агенту присвоен набор тегов, соответствующих используемому оборудованию, программному обеспечению, принадлежность проекту, местоположение и т.д.
  Например, `SAS` (название датацентра, где стоит агент), `LINUX_BIONIC` (операционная система),
  `INTEL_E5_2650V2` (модель процессора), `SSD` (наличие SSD диска) или `IPV4` (наличие IPv4 адреса).
  Полный набор возможных значений тегов можно посмотреть [в коде](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/common/types/client.py).
  Такие предопределенные теги называются **системными** или **клиентскими** тегами.
  Посмотреть как конкретные агенты распределены по тегам можно [на странице clients](https://sandbox.yandex-team.ru/clients/tags).

2. Задаче можно указать логическое теговое выражение, которому должен соответствовать хост.
  Примеры логического выражения: `INTEL_E5_2660 & ~MAN`, `(LINUX_TRUSTY | LINUX_XENIAL) & ~INTEL_E5645`.

3. При запуске задачи Sandbox сопоставляет теговое выражение задачи и теги агента и запрещает запуск задачи на не подходящих хостах.

Кроме **системных** тегов пользователь может создавать собственные (т.е. **пользовательские**) теги и назначать их агентам по своему усмотрению.

![Пользовательские теги](img/agent-user-tags.png "Пользовательские теги")

Пользовательские теги создаются и удаляются в настройках **группы**:

![Добавление и удаление пользовательских тегов](img/agent-edit-user-tag.png "Добавление и удаление пользовательских тегов")
