# Отладка задач

При написании задач основное время отладки уходит на цикл "внес изменения, подождал пока выедет код задач,
запустил задачу, получил результаты".

Эту проблему призваны решить [бинарные задачи](../dev/binary-task.md).
Они позволяют собирать задачу локально, после чего загружать и запускать ее на основной инсталляции Sandbox.
Кроме того, бинарные задачи могут выполняться из командной строки и имеют набор команд для помощи в отладке.
Больше о командах бинарных задач можно посмотреть [тут](../dev/binary-task.md#cli-mode).

Далее приведены основные приёмы, необходимые для дебага задач:
 * [История изменений статусов задачи](#history-tab)
 * [Логирование](#logging)
 * [Web-shell](#web-shell)

## Вкладка History { #history-tab}
На этой вкладке собраны все изменения статусов задач, продолжительность пребывания в определенном статусе, а также указан сервер, который обрабатывал переход статуса (не агент который выполнял задачу, а сервер sandbox, который выполнял операцию смены статуса).
Если в процессе смены статуса или при подготовке запуска задачи возникнет ошибка, ее можно будет увидеть здесь же.

![Вкладка History](../dev/img/history-pane.png "History tab")

## Логирование для отладки { #logging}
Можно добавить больше логов, чтобы узнать больше о состоянии хоста, значении переменных окружения и т.п.

[Как писать логи](../dev/basics.md#logging).

[Как читать логи](../tasks.md#logs).

## Web-shell {#web-shell}
Есть возможность получить доступ до командной строки агента, где исполняется эта задача.
Это даёт возможность продебажить проблему в задаче и получить минимальное воспроизведение.

[Подробнее](web-shell.md#agent-shell)

# Отладка в собственной инсталляции Sandbox { #local-sandbox }

{% note alert %}

Использование собственной инсталляции Sandbox не рекомендуется в силу сложности настройки и поддержания работоспособности всех службы Sandbox.
Оптимальным вариантом является разработка бинарной задачи и отладка её на общем Sandbox, как описано в [разделе про бинарные задачи](../dev/binary-task.md).

{% endnote %}

[Основная статья](../dev/local-sandbox.md)
