# Доступ до командной строки агента
**[Смотреть видео](https://jing.yandex-team.ru/files/guschin/screencast_2016-04-01_14-08-08.mp4)**

Web-shell предоставляет возможность получить доступ до командной строки агента (внутри контейнера), где исполняется эта задача.
Доступ возможен только для владельца задачи и его [группы](../groups.md).

Для подключения к web-shell необходимо сначала переключить задачу в статус SUSPENDED. Чтобы это сделать, есть несколько способов:
* Нажать в UI задачи кнопку **⏸** (suspend).
* Вызвать метод `suspend()` в коде задачи.
{% cut Пример: %}
```python
import logging
from sandbox import sdk2

class MyTestTask(sdk2.Task):

    def on_execute(self):
        # ...
        logging.info("Suspending task...")
        self.suspend()
```
{% endcut %}
* Запустить задачу из UI с опцией `Suspend on status` (раздел _Advanced_)


Когда выполнение задачи приостановлено, можно через веб-интерфейс Sandbox открыть командную строку.

![Открытие командной строки](../dev/img/debug-open-shell.png "Открытие командной строки")


## Приостановка процессов { #sigstop }
В момент приостановки задачи она переводится в [состояние](../tasks.md#status) **SUSPENDING**, а всем её процессам отправляется сигнал **SIGSTOP**.
После приостановки всех процессов задача переходит в состояние **SUSPENDED**.
Пока задача приостановлена, её [время жизни](../tasks.md#ttl) продолжает отсчитываться.
Если вы забудете остановить задачу после завершения отладки, она сама завершится по таймауту.
Тем не менее, мы призываем вас экономить ресурсы кластера и останавливать ненужные вам приостановленные задачи.

## Возобновление выполнения задачи
Для того чтобы возобновить выполнение задачи, нужно нажать на кнопку **▶** (start) в веб-интерфейсе.
При этом процессам задачи отправляется сигнал **SIGCONT**, а задача переходит обратно в состояние **EXECUTING**.


## pygdb { #pygdb }
Получив доступ через web-shell можно использовать [GDB](https://en.wikipedia.org/wiki/GNU_Debugger) с расширением для Python.
Например, можно отобразить стеки всех потоков процесса. Команда называется `pygdb`.

**[Смотреть видео](https://jing.yandex-team.ru/files/korum/screencast%202018-06-28%2020-00-50.mp4)**

1. Приостановите задачу и откройте командную строку.
2. Найдите pid процесса задачи:
    ```bash
    $ ps uxwf | grep Executor
    ```
3. Запустите GDB:
    ```bash
    $ pygdb $PID
    ```
4. Получите распечатку стека вызовов:
    ```
    > thread apply all py-bt # Без перечисления CPython вызовов
    > thread apply all bt # С перечислением CPython вызовов
    ```
