## Общие вопросы

### Какие существуют ограничения на использование REST API?
Для всех пользователей:

* Предел в 3000 элементов на получение списка ресурсов и задач;

Для анонимных (без cookie или хедера с авторизацией) пользователей:

* В информации о ресурсах нет прямых rsync- и http-ссылок (но есть ссылка для скачивания через proxy).


### Я закоммитил изменения, когда они появятся в sandbox?
Для небинарных задач, код выкатываются одним большим архивом, который собирается покоммитно.
После того как для вашего коммита прогонятся тесты
(можно увидеть [тут](https://a.yandex-team.ru/projects/sandbox/ci/actions/launches?dir=sandbox%2Fprojects&id=deploy-build-sandbox-tasks))
и его статус станет **Success** (или статус любого коммита над ним), код выедет на сервера sandbox через пару минут.

Чтобы проверить, на какой ревизии кода задач работают сервера (и на какой будет запущена задача, выданная этим сервером на исполнение), откройте https://sandbox.yandex-team.ru и нажмите на значок **(i)** внизу страницы.

### Изменения из trunk выехали, но в "Create task" я не вижу моей задачи
Если код обновился, а задачу всё ещё не видно, убедитесь, что она достижима по PEERDIR из `/sandbox/projects/`. См. [пример с hello-world](dev/hello-world.md).

### Почему задача долго стоит в очереди в состоянии ENQUEUED?
На странице задачи есть вкладка "Hosts". Там можно посмотреть на каких клиентах разрешено исполнение данной задачи, место в очереди на каждом разрешенном клиенте. Кроме того на этой же вкладке можно посмотреть список возможных проблем — хватает ли места, подходит ли модель CPU, etc.

На позицию задачи в очереди на хост в первую очередь влияет остаток [квоты](quota.md#lack-of-quota) владельца задачи. Посмотреть остаток квоты можно на [странице группы](https://sandbox.yandex-team.ru/admin/groups).

В случае, если задача отмечена как первая в очереди, однако все равно не переходит из состояния "ENQUEUED" в "EXECUTING", проверьте ее зависимости на вкладке "Depends on tasks" - возможно, задача зависит от еще незавершившейся задачи.

Если вы явно указывали хост на котором должен выполниться таск, или выбирали модель CPU, то посмотрите на [страницу информации о клиентах](https://sandbox.yandex-team.ru/clients). Возможно, на машинах кончилось место, или они заняты другими задачами.

Если задача находится не в начале очереди, а вам кажется, что она очень важная, можно воспользоваться кнопкой повышения приоритета со страницы задачи:

![кнопкой](img/inc_priority.png "Кнопка повышения приоритета").

Приоритет задачи `USER:` выдаст квоту ["в кредит"](quota.md#quota-on-credit).


### Я создал задачу, но она перешла в состояние FAILURE, как узнать почему?
`FAILURE` — это корректное завершение задачи с точки зрения Sandbox, но с точки зрения логики задачи не выполнено какое-то условие (упала сборка, провалены тесты). На странице просмотра задачи есть ссылка Logs — это ее логи выполнения. Так же у задачи может быть выставлен флаг `fail_on_any_error` (смотри вкладку Context).
В этом случае задача переходит в FAILURE в случае любой ошибки (EXCEPTION, TEMPORARY).


### Я создал задачу, но она перешла в состояние EXCEPTION, как узнать почему?
EXCEPTION - это внутренняя ошибка кода задачи. На странице задачи можно увидеть traceback. О причинах перехода в это состояние может сказать лог задачи, который можно найти по ссылке Logs. Основной лог - common.log.


### Моя задача работает очень долго, и вдруг внезапно переходит в TIMEOUT. Из-за чего это может быть?
Зайдите на страницу просмотра задачи и найдите параметр `Time to kill` - это максимальное время работы задачи, по его истечению задача переходит в статус `TIMEOUTЕ`


### Почему возникает `ImportError`, хотя нужный мне сторонний пакет есть?
Причина [подобной ошибки](https://paste.yandex-team.ru/809989) в том, что небинарные задачи Sandbox загружаются из исходников на файловой системе и работают в отдельном виртуальном окружении. По умолчанию в нём установлен вот такой [список пакетов](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/requirements.txt), и импорт любого другого пакета на верхнем уровне ожидаемо падает.

У этой проблемы есть два решения:
1. Правильное: [Бинарные задачи](dev/binary-task.md) и `PEERDIR` нужных пакетов из Аркадии.
2. Если первое невыполнимо: [Установка нужных Python-пакетов](https://wiki.yandex-team.ru/sandbox/cookbook/#python-libs) через `PipEnvironment` и требования задач. Это плохой вариант потому, что python2 уже не поддерживается и установка пакетов через pip часто ломается.

Если вы воспользовались методом два - уберите импорты с верхнего уровня и делайте их по месту использования:
Неправильно:
```(python)
from sandbox import sdk2
import yt.wrapper

class Task(sdk2.Task):
    def on_execute(self):
        return yt.wrapper.YtClient(proxy="hahn")
```
Правильно:
```(python)
from sandbox import sdk2

class Task(sdk2.Task):
    def on_execute(self):
        import yt.wrapper
        return yt.wrapper.YtClient(proxy="hahn")
```


### Программа, которую я запустил в задаче, упала в корку, как её скачать?
Если вы запускаете процессы с помощью хелперов Sandbox (`sandboxsdk.process.run_process` или `sdk2.helpers.subprocess.ProcessRegistry`), то:
- сама корка будет лежать в ресурсе `CORE_DUMP` (на странице просмотра задачи также будут надписи вида `GDB traceback is available in task logs: ссылка`), скачать её можно со вкладки `Resources`;
- в ресурсе типа `FILTERED_GDB_TRACEBACK` будет лежать раскрашенный с помощью [coredump_filter](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/sdk2/helpers/coredump_filter) стектрейс.


### Что делать, если задача требует версии модулей, которые конфликтуют с системными?
Правильный путь - использование [бинарных задач](dev/binary-task.md).

Если бинарные задачи использовать не получается, то в модуле `sandbox.sandboxsdk.environments` существует класс (менеджер контекста) `VirtualEnvironment`, создающий с помощью virtualenv временное окружение для исполнения задачи. Пример использования:
```(python)
with VirtualEnvironment('/tmp') as venv:
    venv.pip('pytest==2.5.1 pytest-xdist==1.10 pytest-pep8==1.0.5')
    # or venv.pip('-r requirements.txt')
    suprocess.call([venv.executable, 'somescript.py'])
```


### Почему задача падает с ошибкой `Sharing of resource failed`?

После того, как ресурс задачи перешел в состояние READY его нельзя никак изменять (например, навешивать права на исполнение), так как сразу после того, как на ресурсе ставится READY отметка, в базу записывается skynet_id этого ресурса. Если ресурс после этого модифицировать, то skynet_id изменится и будут возникать такие ошибки:
`copier.share: new ID '...' is not equal to original '...'`
`InvalidResource: [18037f10.2]: agentr.errors.InvalidResource("Skynet ID 'rbtorrent:...' differs from expected u'rbtorrent:...'",)`

Эти ошибки возникают не всегда. Проявляются тогда, когда ресурс синхронизируется rsync'ом. Когда до rsync не доходит и получается синхронизироваться скайнетом, то он выставляет правильные права файлам и при reshare хэши совпадают.


### Задача не запускается с ошибкой `There are no appropriate hosts where this task could be executed`
Данная ошибка означает, что задаче назначены противоречивые фильтры хостов, на которой задаче позволено исполняться, такие, что по результатам фильтрации не осталось ни одного подходящего хоста.

Фильтрация хостов, подходящих для исполнения задачи, происходит в два этапа - сначала строится кеш имен клиентов, подходящих данному типу задачи по её теговому выражению. Далее, при создании задачи указанного типа, можно уточнить фильтр, выбирая их по типу операционной системы, процессора или имени клиента.

{% note info %}

В случае указания имени клиента, __все__ остальные фильтры будут проигнорированы - явное назначение клиента делает бессмысленным применение каких-либо других фильтров.

{% endnote %}

После запуска задачи, выбирается список клиентов, подходящий для данного типа задачи, после чего применяются дополнительные фильтры, заданные при ее создании. Здесь Sandbox может обнаружить, что оставшееся множество совместимых клиентов является пустым. В этом случае, в задачу добавляется запись следующего вида: `There are no appropriate hosts where this task could be executed.`, где далее перечисляется весь список подходящих клиентов из кеша, плюс результаты по каждому фильтру.

Стоит учитывать, что **в случае несоответствия хоста по клиентским тегам** произойдёт несовпадение по платформе с примерно такой ошибкой: `Filter platform results: banned, task parameters: None, client values: Linux-4.4.0-83-generic-x86_64-with-Ubuntu-16.04-xenial`. Например, на локальной инсталляции единственный хост может не соответствовать клиентским тегам задачи -- она может хотеть, например, MULTISLOT. Это лечится или изменением тегов задачи, или редактированием тегов клиента в локальном конфиге.

[Подробнее про фильтры хостов, требования и тэги.](dev/requirements.md)


## Контекст задачи
### Почему задача падает с ошибкой `SandboxTaskCtxError: Sandbox task ... is not serializable` или `TypeError: can't pickle file objects`?
В объекте задачи нельзя хранить ничего, что не сериализуется с помощью `json` (или `pickle` в случае sdk1). [Подробнее](dev/cookbook.md#save_task_state)

Так, первая ошибка возникает при попытке записать в контекст задачи какой-то объект. В контексте можно хранить только базовые типы (`int`, `str`, `list`, `dict`). Никакие объекты (даже datetime) не могут быть сохранены в контекст. Тип `tuple` тоже можно пытаться класть в контекст, но при доставании из контекста вы получите **список** (`list`), поэтому не рекомендуется использовать `tuple`.

Вторая ошибка аналогичная: не получается сериализовать какое-то поле объекта задачи.


### Почему задача падает с ошибкой `DataSizeError: Too large data size`
Это может происходить с задачами написанными на SDK1 по двум причинам:
1. Контекст задачи содержит слишком много данных (для хранения большого объема данных необходимо использовать ресурсы).
2. В атрибутах Python-объекта задачи сохраняется большой объем данных (в SDK1, при завершении выполнения задачи, на сервер передается весь объект задачи упакованный с помощью `pickle`).

В обоих случаях решением может быть либо переписывание задачи на SDK2, либо отказ от хранения "больших" данных в контексте и атрибутах объекта задачи.


### Я записал в контекст задачи поле, но его там не появилось
Контекст задачи не синхронизируется постоянно в БД. Он сериализуется туда, когда задача останавливается или завершается.
Для sdk2-задач можно использовать `self.Context().save()`, для sdk1 можно использовать метод `sandbox.channel.set_task_context_value(task_id, key, value)`.


## Локальный sandbox

### Я написал задачу, но локальный Sandbox её не видит!

1. Если задача новая, нужно перезапустить сервер, чтобы он её опознал: ```~/arcadia/sandbox/sandbox restart_server```.

1. Проверьте, что каждая из директорий в пути к задаче, начиная от [projects](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects), является Python-модулем (содержит файл ```init.py```).

1. Проверьте, что тесты задач, `./sandbox testtasks` или `./sandbox testtasks -s TASK_TYPE`, проходят.

1. Удостоверьтесь, что в логе сервера, `runtime_data/logs/server.log`, нет ошибок, связанных с импортом кода задач.

1. Задача должна располагаться в `init.py`, иначе она будет считаться абстрактной (можно будет только наследоваться).

2. Попробуйте сбросить кеш в браузере или открыть интерфейс в другом браузере. В кэш загрузится список тасок заново, и ваша новая таска появится там.


### Почему задача в локальном Sandbox не может работать с Аркадией и/или валидировать параметры (`svn: E210002: Network connection closed unexpectedly`)?
Локальный Sandbox берёт ключ для доступа в аркадию из ssh-agent, соединение с которым отваливается при закрытии консоли.
Убедиться, что ssh-agent-forwarding включен и работает можно так:
```file $SSH_AUTH_SOCK```
Вернуться должно что то такое: ```/tmp/ssh-IaWJgFFKAH/agent.102005: socket```
В случае, если это не сокет или файл вовсе отсутствует - у вас проблемы с ssh-agent-forwarding
Чтобы пересоздать ssh-agent-socket зайдите на хост по ssh с флагом -A и перезапустите локальный Sandbox.


### Ошибка VaultNotFound (%%No record was found for owner 'None'%%) в локальном Sandbox.
В локальном sandbox намеренно выключена авторизация. Можно положить токен в локальный vault с именем `<some_token>` и пошарить его на пользователя **guest**.
Пользователь guest может обращаться к локальному vault.


### There are no appropriate hosts where this task could be executed на локальной инсталляции
На локальной инсталляции есть всего один клиент - локальный хост. Он может не соответствовать клиентским тегам задачи -- она может хотеть, например, MULTISLOT.
Это лечится или изменением тегов задачи, или редактированием тегов клиента в локальном конфиге.
