# Введение

**[Sandbox](https://sandbox.yandex-team.ru/)** — система выполнения пользовательских задач общего назначения.
Используется для автоматизации процессов: автоматической сборки и тестирования программ, сборки пакетов, обработки данных и так далее.
Автоматические проверки пулл-реквестов в едином репозитории также используют Sandbox в качестве одной из сред исполнения.
Задачи в Sandbox описываются в виде программ на [Python](http://python.org/) (при использовании [тасклетов](https://wiki.yandex-team.ru/sandbox/tasklets/) и на других поддерживаемых языках).

![Из чего состоит Sandbox](img/architecture.png "Из чего состоит Sandbox")

Sandbox состоит из нескольких основных частей:

1. [Веб-интерфейс](https://sandbox.yandex-team.ru) и [API](https://sandbox.yandex-team.ru/media/swagger-ui/index.html) Sandbox
2. Набор из множества машин-**агентов** (также называемых **клиенты**), на которых исполняются задачи
3. [Исходные коды](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects) задач, хранящиеся в едином репозитории

## Основные понятия { #terms }

![Основные понятия](img/terms.png "Основные понятия")

Sandbox использует следующие понятия:

* **Задача** - последовательность действий в виде программы на Python, которую нужно выполнить.
  Например, выполнить какую-то команду, собрать Debian пакет, провести сложные математические вычисления и так далее.
  Задачи выполняются на агентах и в определённом окружении. Во время работы задачи могут получать входные данные через параметры или ресурсы.
  Результаты работы задачи также могут быть представлены в виде выходного параметра или ресурса.
  Задачи могут использовать в работе различные ключи и пароли (секреты), которые загружаются из внешнего сервиса - [Секретницы](https://yav.yandex-team.ru).
  Если требуется ограничивать максимальное количество параллельно выполняющихся задач, то можно воспользоваться семафорами.
* **Агент** - физический сервер или виртуальная машина, на которой выполняются задачи.
* **Окружение задачи** - набор библиотек и зависимостей, которые нужны задаче для работы. Большинство задач запускаются в контейнерах.
  Окружение задачи, как правило, поставляется в виде заранее собранного образа контейнера.
* **Параметр задачи** - данные определенного типа (число, строка, список, словарь и т.п.), используемые задачами.
  Набор параметров задачи определяется автором её кода и зависит от того, что делает эта задача.
  Значения параметров можно передавать через пользовательский интерфейс задачи или Sandbox API при создании задачи.
* **Ресурс** - файл или директория, хранящиеся в специальном хранилище и используемые задачами.
  Ресурсы могут создаваться в процессе выполнения задач. Ресурсы могут скачиваться непосредственно во время работы задачи или передаваться в задачу в виде её параметров.
  В ресурсах обычно хранят данные, которые могут использоваться несколькими задачами одновременно или использоваться во внешних системах, например:
  образы виртуальной машины, Debian-пакеты, редко изменяющиеся конфигурационные файлы и так далее.
* **Семафор** - примитив синхронизации, позволяющий ограничить число параллельно выполняющихся задач.
* **Группа** - множество пользователей, объединенных одним проектом или сервисом. Нужны для управления доступом к задачам и ресурсам, а также для выделения квот.
* **Квота** - количество вычислительных мощностей агентов, доступных для запуска задач, ограничение на суммарное время использования REST API в определенном временном окне,
  а также место в хранилище, доступное для сохранения ресурсов.
