Классический деплой архива Sandbox-задач имеет следующие недостатки:  

* долгий цикл внесения изменений в код задач;
* отсутствие контроля над кодом продакшн-задач: любой разработчик может нарушить исполнение вашей задачи, закоммитив некорректные изменения в код задачи или библиотек, от которых она зависит.

В свою очередь, окружение классических задач:

* ограничивает использование внешних библиотек;
* не даёт переиспользовать кода из Аркадии вне `sandbox/projects`.

Все эти проблемы решены в *бинарных задачах* — более современном способе деплоя и исполнения кода в Sandbox.

*Бинарная задача* — программа, статически собранная в Аркадии из модуля `SANDBOX_PY23_TASK`. Директория с тренировочной задачей `HELLO_%LOGIN%` является именно таким модулем. Соберите её:

```bash
arcadia$ ya make sandbox/projects/tutorial/hello_%login%
```

У получившегося бинаря запустите команду run:
```bash
arcadia$ sandbox/projects/tutorial/hello_%login%/hello run --enable-taskbox
...
Task of type HELLO_%LOGIN% created: https://sandbox.yandex-team.ru/task/%id%
Task started successfully.
```

Она делает следующее:

* загружает бинарь в новый Sandbox-ресурс типа `SANDBOX_TASKS_BINARY` (этот шаг можно выполнить отдельно с помощью команды `upload`);
* создаёт задачу `HELLO_%LOGIN%`, передавая в `Requirements.tasks_resource` ID этого ресурса;
* запускает задачу (шаг можно пропустить передав опцию `--create-only`).

Убедитесь, что команда вернула ссылку на задачу, а сама задача успешно выполнилась.

Задачи с непустым значением `tasks_resource` исполняется именно с использованием указанного в нём бинаря. В него уже включен интерпретатор Python и все зависимости из PEERDIR, поэтому базовое виртуальное окружение и архив задач никак не используются.

Таким образом

* код таких задач зафиксирован, и не зависит от коммитов в Аркадию;
* для тестирования изменений достаточно собрать новый бинарь и запустить на нём задачу; коммитить для этого не обязательно;
* через PEERDIR в задачу можно подключать зависимости из любой точки Аркадии.

Дальнейшие задания в руководстве рекомендуется выполнять именно с помощью бинарных задач.


{% note "Технические детали" %}
Опция `--enable-taskbox` нужна чтобы из бинаря работали серверные методы (такие как `on_save`). Без неё бинарь использоваться только для клиентских методов (`on_prepare`, `on_execute`), а серверные будут исполняться над обычным архивом задач.

Если вы хотите тестировать без коммитов только клиентские методы, опцию можно опустить.

Технология Taskbox пока находится на стадии тестирования, но вполне пригодна для выполнения заданий в этом руководстве. См. подробности в [документации](https://wiki.yandex-team.ru/sandbox/tasks/binary/#taskboxed-task).
{% endnote %}
