Код всех Sandbox-задач находится `sandbox/projects`. Рассмотрим правила, которым должен удовлетворять код в этой директории.

(Если вы выполнили прошлый пункт руководства, можете использовать получившийся коммит как пример выполнения этих правил.)

**Проектная директория:** на первом уровне должны находиться поддиректории проектов/сервисов/команд:

* `sandbox/projects/devtools` (код задач отдела)
* `sandbox/projects/music` (код задач сервиса)
* `sandbox/projects/tutorial` (директория для этого руководства)

Возможно, у ваших коллег уже есть общепринятая поддиректория. Располагать код задач в корне `sandbox/projects` запрещено.

**Пакет с задачей:** для каждой новой задачи нужно завести отдельный Python-пакет внутри проектной директории:

* `sandbox.projects.tutorial.hello_%login%` (тренировочная задача в этом руководстве)
* `sandbox.projects.common.build.YaMake2` (пакет с задачей YA_MAKE_2)

Название пакета и уровень вложенности могут быть любыми, главное чтобы во всех поддиректориях должен присутствовал `__init__.py`, иначе пакет не будет импортироваться.

**Класс Sandbox-задачи** может быть объявлен только в `__init__.py` пакета задачи, причём в одном файле может быть объявлена только одна задача.

**Аркадийная сборка:** во всех директориях должен быть файл `ya.make`. Эти файлы описывают зависимости кода и правила его сборки ([подробнее](https://wiki.yandex-team.ru/yatool/howtowriteyamakefiles/)).

Всё содержимое `sandbox/projects` должно быть покрыто графом сборки, иначе оно будет проигнорировано Sandbox:

* пакет с задачей должен быть модулем SANDBOX_PY23_TASK. Весь его код должен быть подключен через PY_SRCS, остальные файлы — через RESOURCE, импортируемые зависимости — через PEERDIR ([подробнее](https://wiki.yandex-team.ru/sandbox/tasks/tests/));
* промежуточные `ya.make` должны быть иметь тип PY23_LIBRARY, а все пакеты с задачами должны быть достижимы по PEERDIR от корня `sandbox/projects`.

Схематично это выглядит так:

![code structure](https://wiki.yandex-team.ru/users/mkznts/sandbox-tutorial/02-code-structure/.files/codestructure.png)
