**Объявлять ресурсы**, как и задачи, нужно специальными Python-классами. Делать это можно в любом модуле внутри `sandbox/projects`, главное чтобы он импортировался хотя бы в одной задаче. Названия типов ресурсов тоже формируются из названий классов, имеют формат SCREAMING_SNAKE_CASE и должны быть уникальными.

 В нашем случае ресурс `GREETING`, который создаёт задача `HELLO_%LOGIN%`, объявлен в пакете [sandbox/projects/tutorial/common](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/tutorial/common):
```
from sandbox import sdk2

class Greeting(sdk2.Resource):
    # Common attributes:
    releasable = True
    restart_policy = ctr.RestartPolicy.DELETE
    ttl = 3  # days
    # User attributes:
    login = sdk2.resource.Attributes.String("Login")
```

**Атрибуты ресурсов:**

* *Общие*, для которых нужно задать лишь значения по умолчанию, и *пользовательские*.
* В пользовательский атрибут `login` мы сохраняем логин человека, которому адресовано приветствие. По таким атрибутам можно искать ресурсы в Sandbox, это понадобится нам в **TODO**.
* Среди общих атрибутов нам пока интересен только `ttl`: он задаёт гарантированное время жизни ресурса в днях с момента последнего использования.
* Более подробно атрибуты ресурсов и время жизни описаны в [документации](https://wiki.yandex-team.ru/sandbox/resources/).

**Создание ресурса** начинается с создания объекта его класса. Класс можно либо импортировать напрямую (как уже сделано в `HELLO_%LOGIN%`), либо получить из `sdk2.Resource` по названию ресурса:

```python
def on_execute(self):
    ...
    resource = sdk2.Resource["GREETING"](
        self,  # объект задачи, к которой будет привязан ресурс (почти всегда — текущая задача)
        description="Special greeting",  # описание ресурса в интерфейсе
        path="greetings",  # путь к файлу или директории ресурса
                           # (относительный или абсолютный, но всегда внутри директории задачи)
        login="mkznts",  # опционально — значения атрибутов
    )
```

Если путь из аргумента `path` уже существует, больше ничего делать не надо — ресурс создан, и при завершении задачи будет автоматически переведён в состояние READY. Но в `HELLO_%LOGIN%` это не так — мы лишь собираемся подготовить файлы для ресурса. Для этого нужен ещё один объект:
```python
resource_data = sdk2.ResourceData(resource)
resource_data.path  # -> объект типа `pathlib2.Path`, указывающий на файл или директорию ресурса
```

> `pathlib2` — бэкпорт стандартного пакета `pathlib` из Python 3, см. [документацию](https://docs.python.org/3/library/pathlib.html))

Для создания ресурса из одного файла достаточно скопировать или записать в `resource_data.path` нужные данные напрямую:
```python
# Ресурс из одного файла
with resource_data.path.open("w") as f:
    f.write(text)
```

Для создания ресурса с директорией её сначала необходимо создать, а потом создать или скопировать в неё нужные файлы:
```python
# Ресурс из директории
resource_data.path.mkdir()
with (resource_data.path / "hello.md").open("w") as f:
    f.write(text)
```

> Использовать методы `pathlib2.Path` не обязательно: преобразование `resource_data.path` в строку даёт обычный абсолютный путь, который можно использовать в других пакетах (`os.path`, `shutil` и пр.)

Когда ресурс готов, `resource_data` позволяет вручную перевести его в состояние READY (хотя это и не обязательно: при успешном завершении задачи это будет сделано автоматически):
```python
resource_data.ready()
```
