# Вычислительные ресурсы { #resources }

По умолчанию Sandbox-задача занимает клиент в одиночку и может пользоваться всеми его ресурсами монопольно. Таким задачам можно утилизировать все 32/48/56 CPU и сотни гигабайт RAM. Также, это полезно для задач чувствительных к «соседям» — например, для стрельб.

Существуют также *многослотовые* клиенты (multislot), которые выполняют несколько задач сразу. На них следует выполнять легковесные задачи, требующие не более нескольких ядер CPU. 

Чтобы выполняться на многослотовом клиенте, задача должна декларировать:

* требования ядер и RAM в одной из конфигураций:
  * 1 CPU & RAM ≤ 8 Гб
  * 4 CPU & RAM ≤ 16 Гб 
  * 8 CPU & RAM ≤ 32 Гб
* что не будет использовать VCS-кэши (== не будет работать с Аркадией).

Делается это с помощью атрибутов `cores`, `ram` и `Caches` в requirements, которые мы уже видели в тренировочной задаче `HELLO_%LOGIN%`:

```python
class Requirements(sdk2.Requirements)
    ram = 1024  # MiB
    cores = 1
    class Caches(sdk2.Requirements.Caches):
        """ No caches required """
```

> Именно *присутствие* пустого класса `Caches` декларирует то, что задаче не нужны кэши. По умолчанию считается, что задача их требует.

Более подробно о многослотовых клиентах читайте в [документации](https://wiki.yandex-team.ru/sandbox/cookbook/#multislot).

# Операционная система { #os }

На Linux-хостах Sandbox-задачи запускаются в [LXC-контейнерах](https://en.wikipedia.org/wiki/LXC). По умолчанию это Ubuntu 12.04, но можно выбрать и другую версию: добавите тег `LINUX_*` в опции `client_tags` в коде задачи или при её запуске (*Advanced → Client tags* в UI):

```python
from sandbox.common.types import client as ctc

class Requirements(sdk2.Requirements):
    ...
    client_tags = ctc.Tag.LINUX_BIONIC
```

> Точно понять, на каком контейнере запустилась задача, можно из debug.log. В самом начале лога должна быть подобная строчка:
>
> ```Switching cgroup to /sysdefault/lxc/1033498921.5/sandbox/executor```
>
> 1033498921 — номер [ресурса с LXC-образом](https://sandbox.yandex-team.ru/resource/1033498921/view). Судя по его атрибутам, это Ubuntu 12.04

По умолчанию выбираются стандартные контейнеры с фиксированным набором пакетов. Также есть возможность собирать собственные LXC-образы для задач, которым нужен дополнительный системный софт, см. **TODO**.

# Пользователь { #user }

По умолчанию код задачи запускается от непривилегированного пользователя `sandbox`. С помощью опции `privileged` можно  включить исполнение от `root`, если это необходимо:

```python
class Requirements(sdk2.Task.Requirements):
    ...
    privileged = True
```

> Изменить значение `privileged` из UI напрямую нельзя. Если это необходимо — добавьте к задаче параметр и в зависимости от него изменяйте `self.Requirements.privileged` в `on_save` или `on_enqueue`.

Подробнее про привилегированный режим и его ограничения см. в [документации](https://wiki.yandex-team.ru/sandbox/cookbook/#privileged-task).

# Файловая система { #fs }

У каждой задачи есть специальная директория (далее — *директория задачи*), в которой разрешено создавать пользовательские данные. Она имеет вид `/place/sandbox-data/tasks/9/8/123456789`, название последней поддиректории равно номеру задачи.

Директория задачи является текущей в `on_execute`. Её также можно получить из метода `self.path()`:

```python
def on_execute(self):
    os.getcwd()  # -> "/place/sandbox-data/tasks/9/8/123456789"

    self.path()
    # -> Path("/place/sandbox-data/tasks/9/8/123456789")

    self.path("foo", "bar")
    # -> Path("/place/sandbox-data/tasks/9/8/123456789/foo/bar")
```

Только на директорию задачи распространяется гарантия `disk_space`, указанная в requirements. Крайне нежелательно записывать файлы в другие директории (в том числе в `/home/sandbox`) даже при наличии прав: они смонтированы на другой раздел, где свободное место сильно ограничено. Если вы запускаете сторонние программы, перенастройте их рабочие директории внутрь директории задачи.

Это же касается и временных файлов. Внутри задачи определены переменные окружения TEMP, TMP и TMPDIR, которые указывают на директорию `tmp` внутри директории задачи. Это позволяет использовать стандартную библиотеку [tempfile](https://docs.python.org/2/library/tempfile.html) и другой софт, который уважает эти переменные. Не используйте `/tmp` и `/var/tmp` для временных файлов.

```python
import tempfile

def on_execute(self):
    tempfile.mkdtemp()
    # -> "/place/sandbox-data/tasks/9/8/123456789/tmp/tmpDzvhUT"
```

# Python { #python }

Задачи, код которых деплоится [классическим](./task-deploy.md) способом, мы тоже будем называть *классическими*.

> Слово *классический* здесь используется как противовес к более современным *[бинарным задачам](./binary-tasks.md)*.

Код классических задач работает на CPython 2.7.8 из поставки [Skynet](https://wiki.yandex-team.ru/skynet/python/). Задача запускается как обычный python-скрипт в базовом виртуальном окружении где доступны:

* библиотеки Sandbox: `sandbox.sdk2`, `sandbox.common`, `sandbox.sandboxsdk`;
* код задач: `sandbox.projects`
* библиотеки skynet;
* внешние библиотеки из [sandbox/requirements.txt](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/requirements.txt).

Такое же виртуальное окружение предоставляется серверным методам, таким как `on_save` и `on_enqueue`. В этом режиме нельзя импортировать весь остальной код из Аркадии, PEERDIR тут не играет никакой роли.

Список внешних библиотек небольшой и крайне редко пополняется. Тем не менее, в следующем разделе будет показано, как устанавливать в это виртуальное окружение дополнительные пакеты.
