# Sandbox Proxy

Sandbox Proxy — это сервис, доступный всем внутренним пользователям Яндекса (ALL_STAFF)
и предназначенный для скачивания файлов или просмотра логов задач по HTTP(S).

{% note info %}

Sandbox Proxy не рассчитан на большую нагрузку, а потому его крайне не рекомендуется использовать для доставки ресурсов
на большое количество серверов (например, в production-окружение). Для этих целей надо использовать Skybone.

{% endnote %}


## Возможности { #features }

Например, вам требуется скачать ресурс типа `<RESOURCE_TYPE>` с идентификатором `<RESOURCE_ID>`.


### Скачивание по прямым ссылкам { #direct-links }

Если ресурс состоит из одного файла, то воспользуйтесь ссылкой:

`https://proxy.sandbox.yandex-team.ru/<RESOURCE_ID>`

Если ресурс является директорией, `.tar`- или `.tgz`-архивом,
то для скачивания кокретного файла внутри ресурса сработает ссылка вида:

`https://proxy.sandbox.yandex-team.ru/<RESOURCE_ID>/path/to/filename.txt`



### Просмотр рабочей директории задачи { #task-directory }

Для задачи под номером `<TASK_ID>` можно просмотреть содержимое её рабочей директории во время и после исполнения по следующей ссылке:

`https://proxy.sandbox.yandex-team.ru/task/<TASK_ID>`

Как и в прошлом примере, здесь в этом случае будет работать обращение к отдельным файлам.


### Сжатие { #compression }

Если ресурс является директорией, то целиком его скачать по http можно только в виде `.tar` или `.tgz` архива.
Для этого надо указать параметр `stream=tgz` или `stream=tar`:
`https://proxy.sandbox.yandex-team.ru/<RESOURCE_ID>?stream=tar`

Таким образом можно скачивать ресурсы, состоящие из директории с файлами:
```bash
curl http://proxy.sandbox.yandex-team.ru/251435560?stream=tgz | tar zxf -
```


### Фильтрация ресурсов { #filtering }

Proxy позволяет найти и получить последний созданный ресурс заданного типа с учётом атрибутов и других свойств.
Фильтрация возможна по всем параметрам,
что и [в соответствующем методе REST API](https://sandbox.yandex-team.ru/media/swagger-ui/#!/resource/resource_list):
`arch`, `attrs`, `task_id`, etc.

Шаблон запроса:
```
https://proxy.sandbox.yandex-team.ru/last/<RESOURCE_TYPE>[/<path/to/file.ext>][?attrs={"<name>":"<value>"}&task_id=<id>]
```

Например, последний стабильный релиз ресурса `SANDBOX_ARCHIVE` с атрибутом `type=library` можно получить так:
```
https://proxy.sandbox.yandex-team.ru/last/SANDBOX_ARCHIVE?attrs={"released": "stable", "type": "library"}
```


### Докачивание { #byte-ranges }

Прокси поддерживает частичное скачивание данных при помощи HTTP-заголовка [Range](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Range).

Например, скачать первый килобайт ресурса можно так:
```bash
curl https://proxy.sandbox.yandex-team.ru/<RESOURCE_ID> -i -H "Range: bytes=0-1023"
```

Заголовок `Range` не будет работать с параметром `stream={tar,tgz}`.


## Выбор источника { #sources }
Sandbox Proxy всегда отдает валидную ссылку на ресурс: он самостоятельно перебирает все источники данных ресурса, пока не найдет доступный.
Если доступно несколько источников, то ресурс будет отдаваться с наиболее приоритетного:
приоритет зависит от скорости ответа, локации и специализации хоста.
В случае, когда содержимое отдать невозможно, прокси отвечает [одним из кодов ошибок](#http-codes).

## Коды возврата { #http-codes }
При скачивании Sandbox Proxy может вернуть один из следующих кодов возврата:

Код | Описание
:--- | :---
**200 OK** | Ресурс найден.
**307 Temporary Moved** | Ресурс не загружен до конца. Дополнительно отдается заголовок `Retry-After` со значением, равным количеству секунд, в течение которых предполагается завершение процесса загрузки, а также заголовок `Location`, равный запрошенному URL.
**404 Not Found** | Не существует ресурс или запрашиваемый файл внутри ресурса. Различить эти ситуации можно по наличию заголовка `X-Sandbox-Resource-Id` и по содержимому поля `reason` в ответе на запрос.
**410 Gone** | Ресурс не загружен до конца, а загружавшая его задача завершилась.
**503 Service Not Available** | Все источники данных для ресурса недоступны.


## Заголовки запроса { #request-headers }

Заголовок | Описание
:--- | :---
`X-Ignore-State` | игнорировать состояние ресурсов при запросе их данных не из браузера – позволяет скачивать данные ресурса в состоянии **BROKEN** или **DELETED**.


## Заголовки ответа { #response-headers }

Заголовок | Описание
:--- | :---
**X-Sandbox-Resource-Id** | Идентификатор отдаваемого ресурса
**X-Backend-Request-Id** | Идентификатор запроса на сервере. Используется для отладки.
**X-Backend-Node** | Имя сервера, который обработал запрос.
**X-Data-Source** | Имя сервера, с которого отдаются данные ресурса.
