# Планировщики и запуск по расписанию

Планировщики предназначены для настройки регулярных запусков задач по расписанию.
Для быстрого же ручного запуска задач с предзаполненными параметрами стоит использовать [шаблоны](templates.md)
([анонс](https://clubs.at.yandex-team.ru/sandbox/3370)).

Существующие планировщики можно найти [на соответствующей странице](https://sandbox.yandex-team.ru/schedulers).
Создать новый регулярный запуск задач можно с любой страницы Sandbox, нажав кнопку **Create -> Scheduler** в верхней части web-интерфейса.
При этом надо будет указать тип задачи, заполнить параметры задачи и настроить расписание запуска.

Планировщики всегда следует создавать с указанием группы-владельца. Также мы рекомендуем в качестве автора указывать робота.
Эти действия позволяют не потерять доступ к планировщику в случае ухода сотрудника в отпуск или его увольнения. Более того, в Sandbox есть специальные проверки, которые переведут планировщик в статус STOPPED, если автор перестанет входить в группу-владельца.

Изменить владельца планировщика можно только на робота доступного к управлению автору планировщика через роль ["Управление роботами"](https://wiki.yandex-team.ru/intranet/abc/docs/robots/)


## Параметры запуска по расписанию { #parameters }

**Start execution** - когда запустить "первую" задачу:
- `Immediately` — сразу же после включения планировщика;
- `Set timer` — в заданные дату и время (если они расположены в прошлом,
  задача запустится с учётом цикличности, установленной в **Repetition rules**).

{% note warning %}

После обновления или перезапуска планировщика задачи запускаются согласно настройке **Start Execution**,
  независимо от уже имеющихся задач и прочих правил запуска.

{% endnote %}

**Repetition rules** – правила, по которым создаются новые задача:
- `None` — не планировать запуски самостоятельно, используется для разового ручного запуска;
- `Set time interval` — период создания, с которым планировщиу создаёт и запускает задачи.
  Фактическое время создания задачи может отличаться от заданного на десятки секунд.
- `Set days` — запускать задачу в заданное время (время создания планировщика по умолчанию) в указанные дни.

{% note warning %}

При запуске задач Sandbox не учитывает временную зону пользователя и потому день недели определяется по времени в UTC.
При этом в web-интерфейсе будет отображаться ваше локальное время.

Пример: если настроить запуск **по понедельникам** в 02:00 MSK, то задача запустится в 02:00 MSK **вторника**,
потому что по UTC в этот момент будет ещё понедельник.]>

{% endnote %}

**Retry on failure** — политика перезапуска при падении задачи (в случае перехода в статус `FAILURE`):
- `None` — ничего не делать (не отклоняться от расписания);
- `In interval` — запустить новую задачу не по расписанию, а через заданное время;
- `Failure` — переводить планировщик в состояние `FAILURE`, после чего он перестанет запускать новые задачи до ручного вмешательства.

**Sequential run** — не запускать следующую задачу до тех пор, пока не завершилась предыдущая.
Включение этой опции приводит к выставлению флага **fail_on_any_error** для каждой запускаемой задачи.
Этот флаг приводит к тому, что задача принудительно переключается в `FAILURE` в случае перехода в статусы из группы
[FAIL_ON_ANY_ERROR](https://a.yandex-team.ru/arc_vcs/sandbox/common/types/task.py?rev=r8088426#L406).
Это делается, чтобы не допустить параллельную работу двух и более задач одного планировщика.

## Состояния планировщиков { #statuses }

Имя | Описание
:--- | :---
`DELETED`  | планировщик удалён
`WATCHING` | планировщик следит за выполнением созданной задачи
`WAITING`  | ожидание времени старта новой задачи
`STOPPED`  | планировщик остановлен, либо последняя задача завершилась неудачно, а политика перезапуска не задана
`FAILURE`  | последняя задача завершилась неудачно, а параметр `Retry on failure` выставлен в `Failure`

## Как работают планировщики { #scheduling }

В Sandbox есть сервисный процесс, с некоторым интервалом опрашивающий каждый планировщик и определяющий его статус.

Если запуск по расписанию отключен и был сделан однократный успешный запуск задачи, то планировщик переключается в `STOPPED`.

Для каждого планировщика вычисляется время, когда должен произойти следующий запуск задачи.
Если это время ещё не наступило, то планировщик будет в статусе `WAITING`.
Если это время наступило, то создаётся и запускается новая задача, а планировщик переходит в статус `WATCHING`.
До тех пор, пока задача находится в одном из состояний групп `QUEUE`, `WAIT` или `EXECUTE`, планировщик остаётся в состоянии `WATCHING`.
