# Семафоры

**Семафор** - именованный [счётчик](https://en.wikipedia.org/wiki/Semaphore_(programming)), при помощи которого можно управлять количеством одновременно исполняющихся задач. Обычно семафоры используются в ситуациях, когда нагрузка, создаваемая Sandbox, превышает нагрузку, которую может выдержать пользовательский сервис используемый задачами. Например, при использовании Sandbox для тестирования веб-приложения можно создать семафор, чтобы ограничить число параллельно исполняющихся тестов.

## Список семафоров { #list }

Полный список семафоров можно посмотреть на странице [Semaphores](https://sandbox.yandex-team.ru/admin/semaphores) (меню **More > Semaphores**).

![Список семафоров](img/semaphore-list.png "Список семафоров")

На странице каждой задачи можно посмотреть список используемых ей семафоров:

![Семафоры, используемые задачей](img/semaphore-task.png "Семафоры, используемые задачей")

## Имя семафора { #name }

У каждого семафора есть **уникальное имя**, использующееся при взаимодействии с ним в коде задачи.

## Тип семафора { #type }

Существует два типа семафоров:

* **Автоматические семафоры (AUTO)**. Создаются задачей во время работы. Если они не используются некоторое время, то автоматически удаляются.
* **Постоянные семафоры (PERSISTENT)**. Создаются заранее разработчиком задачи и используются несколькими задачами одновременно.

{% note info %}

автоматический семафор можно сделать постоянным и наоборот на странице редактирования семафора

{% endnote %}

## Емкость семафора { #capacity }

У каждого семафора есть **ёмкость**, т.е. максимальная сумма весов с которыми он может быть захвачен исполняющимися задачами.

## Значение семафора { #value }

В каждый момент времени у семафора есть **значение**, то есть сумма весов с которыми он **уже** захвачен исполняющимися задачами.

## Владелец семафора { #owner }

У каждого семафора есть владелец - **группа**, создавшая его. Владелец также может выдавать доступ к семафору другим группам.

## Как работает семафор { #how-it-works }

1. При запуске задачи загружается список имеющихся семафоров. Если задача требует создания семафора с несуществующим именем, он автоматически создается.
2. Задача пытается захватить семафор ёмкостью `N` с определенным весом `w`. Например, если требуется запустить 5 параллельных задач, то у семафора будет захвачено число `5 * w`. При этом в семафоре остаётся доступно `(N - 5 * w)` свободных мест, для большенства задач `w = 1`.
3. Если в семафоре не осталось свободных мест, то при попытке захватить семафор, задача блокируется в состоянии **WAIT_MUTEX**.
4. Если задача, захватившая семафор, завершается, то такой семафор автоматически освобождается, но при определении требования семафоров у задачи может быть указан определенный список статусов задачи при переходе в которые семафоры будут отпущены. Также есть возможность явно отпустить захваченные задачей семафоры из кода задачи во время ее исполнения.

## Как создать семафор { #create }

Для создания нового семафора нажмите на **Create > Semaphore**, укажите имя, владельца и емкость:

![Создание семафора](img/semaphore-create.png "Создание семафора")

## Как использовать семафор { #use }

Семафоры используются в коде задачи. Подробно о том как это делать, описано [здесь](dev/semaphores.md).
