## Поддержка пользователей { #support }

Данная документация призвана ответить на вопросы, которые могут возникнуть при работе с Sandbox.
В случае, если документации не хватает или возникают более сложные вопросы, вы можете задать их
[через нашу форму обращений](https://forms.yandex-team.ru/surveys/65090/?service=sandbox).
В этом случае будет создан тикет, в который придёт наш дежурный и обязательно поможет.

### Советы по заведению обращений в Sandbox { #tips }

**Если проблема воспроизводится, постарайтесь найти минимальный пример для воспроизведения.**
Это позволит разработчикам Sandbox быстрее локализовать проблему, а значит и найти решение.
Часто построение минимального примера, воспроизводящего проблему, позволяет найти ошибку в коде самой задачи.
Ознакомьтесь с [разделом про отладку задач](debug/debug.md).

Пример хорошего обращения:
```
Я пытаюсь собрать docker-образ, процесс зависает на шаге "apt-get update".

curl https://paste.yandex-team.ru/9739208/text -o /tmp/image.txt
docker build - < /tmp/image.txt
```

**Давайте больше предыстории.**
Частый вопрос "раньше задача работала, а теперь сломалась" влечёт за собой встречный вопрос "а что изменилось?".
Приложите ссылки на предыдущие успешные запуски.
Убедитесь, что дело не в одном из следующих пунктов, которые контролируются пользователем и/или владельцем задачи:
- изменение [параметров запускаемой задачи](tasks.md#input-parameters);
- изменение [требований к задаче и агенту](tasks.md#requirements);
- изменение [бинаря задачи](dev/binary-task.md);
- изменение [контейнера](dev/environment.md#containers);
- изменение [используемых ресурсов](dev/resources.md#search-and-download).

**Используйте существующие инструменты для самостоятельной диагностики.**
Читайте [логи](debug/debug.md#logging), файлы [atop](tasks.md#atop-log),
используйте [web-shell](debug/web-shell.md), проверьте [чеклист при проблемах с сетью](debug/network.md).

**Разделяйте проблемы.**
Заводите отдельные тикеты по новым проблемам.
Не стоит в одном обращении писать о разных проблемах. Лучше сделать два разных тикета.

**Попробуйте поискать текст ошибки по [очереди DEVTOOLSSUPPORT](https://st.yandex-team.ru/issues/433629)**


## Аварийные ситуации { #emergency }
Если вопрос **крайне важный и связан с нарушением работоспособности продуктовых процессов** (т.е. вы подозреваете полную или частичную неработоспособность Sandbox) —
пишите [в telegram-чат sandbox-emergency](https://t.me/joinchat/BLQp10XNMTrbGctZrctfGg).

{% cut "Принципы функционирования чата" %}

Чат ``sandbox-emergency`` является своего рода тревожной кнопкой — способом связи с командой разработки в любое время суток.
По внутреннему регламенту при получении сообщения в чате члены команды разработки Sandbox должны отложить любые текущие дела, чтобы ответить на сообщение.

Кроме этого, на чат подписан наш бот, который при отсутствии ответа на сообщение более чем 5 минут в любое время суток
начинает телефонную эскалацию членам команды разработки Sandbox, начиная с текущего дежурного.

{% endcut %}
