# Задачи

Основным объектом в Sandbox является **задача** (task), т.е. последовательность действий, которую нужно выполнить. Каждая задача выполняется в отдельном контейнере (кроме не Linux платформ, на Windows и Mac OS задачи запускаются на самом хосте), который удовлетворяет **требованиям задачи** (число процессорных ядер, количество оперативной памяти, наличие SSD диска и т.п.). Сервер на котором выполняются эти контейнеры называется **агентом**. Каждой задаче при создании присваивается **уникальный числовой идентификатор** (например, 817032090).

![Основные свойства задачи](img/task-properties.png "Основные свойства задачи")

## Список задач { #list }

Список задач можно посмотреть на странице [Tasks](https://sandbox.yandex-team.ru/tasks). По-умолчанию эта страница показывает задачи, созданные текущим пользователем, и может быть пустой.

![Список задач](img/task-list.png "Список задач")

При помощи элементов фильтрации можно показать задачи, удовлетворяющие нужным параметрам.

## Окружение задачи { #environment }

Описание задачи в виде кода на Python определяет **последовательность шагов**, которую нужно выполнить. В большинстве случаев требуется также указать **в каком окружении** и **над какими данными** нужно выполнить эти шаги. **Окружение задачи** - это программы, библиотеки, утилиты и любые другие зависимости, необходимые для корректной работы задачи. Окружение задачи создается в виде образа формата [LXC](https://linuxcontainers.org/) или [Porto](https://github.com/yandex/porto). Существуют [готовые задачи](https://sandbox.yandex-team.ru/tasks?children=false&hidden=false&type=SANDBOX_LXC_IMAGE) для сборки окружения из Bash-скрипта. Обычно образ с окружением задачи меняется нечасто и используется для запуска множества задач. Если не указывать конкретное окружение у задачи, она будет запущена в окружении по-умолчанию, которое поддерживает команда Sandbox.

## Входные параметры { #input-parameters }

![Входные параметры задачи](img/task-input-parameters.png "Входные параметры задачи")

**Входные параметры** (input parameters) - это данные, используемые задачей в своей работе. Входные параметры определяются в коде задачи и могут иметь различный [тип](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/sdk2/parameters.py), например:

* **Целое** и **вещественное** число
* **Строка**: простая, с проверкой регулярного выражения, путь до репозитория
* **Логическое (булево) значение** (флажок)
* **Переключатель** (радио кнопки)
* **Список** значений и пар ключ-значение
* **Секрет**: пароль, SSH-ключ и так далее, загружаемый из [Секретницы](https://yav.yandex-team.ru/)
* **Ресурс**: см. следующий раздел.
* **Выбор сотрудника** со [Staff](https://staff.yandex-team.ru)

Можно определить обязательные и необязательные параметры, а также указать значения по-умолчанию. Можно создавать группы параметров и параметры, отображение которых зависит от других параметров. После запуска задачи входные параметры **нельзя изменить**.

## Выходные параметры { #output-parameters }

Задача может в любой момент поделиться данными, полученными во время работы. Если эти данные не сохраняются в [ресурс](resources.md), их можно передать в виде т.н. **выходных параметров**. Выходные параметры могут иметь такие же типы что и входные, но в отличии от них их значение может быть установлено во время работы задачи, **но только один раз**. Примеры использования выходных параметров:

1. Внешняя система запускает задачу, дожидается ее завершения и забирает результат через API.
2. Запускается две задачи, одна из которых подписывается на состояние другой и ждет от нее результатов.

## Тип задачи { #type }

У каждой задачи есть **тип**, например, **REMOTE_COPY_RESOURE** или **MARKET_FRONT_CI**. Тип задачи указывается при ее запуске и также позволяет фильтровать список задач, выполняющих один и тот же код. Обычно тип задачи формируется из названия класса в коде задачи.

{% note info %}

Имя типа задачи всегда определяется в верхнем регистре.

{% endnote %}

![Фильтрация задач по типу](img/task-type.png "Фильтрация задач по типу")

## Состояние задачи { #status }

У каждой задачи есть состояние, например, **черновик** (**DRAFT**), **в очереди** (**ENQUEUED**), **выполняется** (**EXECUTING**) и так далее.
В таблице ниже приведены все возможные состояния задач.

Группа статусов | Состояние | Описание
:----: | :--- | :---
<span style="color:darkred">**FINISH**</span> | **NOT_RELEASED** | Во время создания релиза произошла ошибка.
&nbsp;| **SUCCESS** | Задача полностью завершилась.
&nbsp;| **RELEASED** | Релиз задачи успешно создан.
&nbsp;| **DELETED** | Задача удалена из системы.
&nbsp;| **RELEASING** | Из задачи формируется [релиз](dev/releases.md).
&nbsp;| **FAILURE** | Задача завершилась, но с точки зрения логики задачи какое-то условие не выполнено (тесты упали, бинарник не собрался, RPS базового поиска при обстреле просел в 100500 раз).
<span style="color:darkred">**EXECUTE**</span> | **TEMPORARY** | При подготовке или выполнении задачи произошла устранимая временная проблема или ошибка окружения (например, внезапный отказ сервера из-за аппаратных проблем). Задачи, попавшие в это состояние, автоматически перезапускаются через некоторое время или могут быть остановлены.
&nbsp;| **SUSPENDING** | Нажата кнопка **Suspend** и задача переводится в режим отладки. Всем процессам задачи отправляется сигнал **SIGSTOP**.
&nbsp;| **ASSIGNED** | Задача назначена на клиента, и он занимается подготовкой к запуску задачи. В это время может происходить запуск контейнера, обновление кода задач.
&nbsp;| **EXECUTING** | Код задачи исполняется.
&nbsp;| **PREPARING** | Задача готовит окружение для начала исполнения: разворачивается окружение и выполняются подготовительные действия, описанные в коде задачи.
&nbsp;| **SUSPENDED** | Процессы задачи остановлены для отладки. Из веб-интерфейса можно получить командную строку на соответствующем агенте. Таймаут на время исполнения задачи продолжает отсчитываться. При нажатии на кнопку **Start** процессам задачи отправляется сигнал **SIGCONT** и задача переходит в состояние **RESUMING** и далее в состояние из которого была остановлена.
&nbsp;| **RESUMING** | Переходный статус после продолжения задачи из статуса **SUSPENDED**.
&nbsp;| **STOPPING** | Запрошена остановка задачи пользователем или Sandbox, также через этот статус происходит переход в статусы **WAIT_***. Задачи в этом статусе не могут быть перезапущены и в случае ошибки (даже инфраструктурной) переходят в **EXCEPTION**.
&nbsp;| **FINISHING** | Исполнение кода задачи завершено, идет очистка от мусора, сохраняются созданные ресурсы.
&nbsp;|&nbsp;|&nbsp;
<span style="color:darkred">**QUEUE**</span> | **ENQUEUING** | Задача ставится в очередь.
&nbsp;| **ENQUEUED** | Задача стоит в очереди, ожидает назначения на клиенты и начала исполнения.
&nbsp;|&nbsp;|&nbsp;
<span style="color:darkred">**DRAFT**</span> | **DRAFT** | Черновик задачи. Задача еще не поставлена в очередь на исполнение. В этом состоянии можно редактировать входные параметры задачи или удалить ее (перевести в состояние **DELETED**).
&nbsp;|&nbsp;|&nbsp;
<span style="color:darkred">**WAIT**</span> | **WAIT_TIME** | Задача ждет указанное количество времени (см. функцию **wait_time**).
&nbsp;| **WAIT_MUTEX** | Если в семафоре не осталось свободных мест, то при попытке захватить семафор, задача блокируется в этом состоянии.
&nbsp;| **WAIT_OUT** | Задача ожидает установки выходных параметров другой задачи.
&nbsp;| **WAIT_RES** | Задача ожидает завершения создания ресурса, от которого зависит.
&nbsp;| **WAIT_TASK** | Задача ожидает завершения подзадачи.
&nbsp;|&nbsp;|&nbsp;
<span style="color:darkred">**BREAK**</span> | **NO_RES** | Задача остановлена, так как не выполнены ее требования: например, задача зависит от ресурса в состоянии **DELETED** или &nbsp;| **BROKEN**.
&nbsp;| **EXCEPTION**| Задача во время исполнения выбросила исключение.
&nbsp;| **STOPPED** | Задача остановлена.
&nbsp;| **TIMEOUT** | Задача остановлена, так как превысила ограничение на время исполнения на клиенте.
&nbsp;| **EXPIRED** | Задача остановлена, так как превысила ограничение на общее время исполнения.

## Требования задачи { #requirements }

В коде любой задачи могут быть указаны требования к вычислительным ресурсам, например:

* Число процессорных ядер
* Модель процессора
* Доступная оперативная память
* Размер и тип диска (например, SSD)
* Необходимость запуска в определенном окружении
* Операционная система: Linux, Windows, MacOS
* Поддержка [NAT64](https://en.wikipedia.org/wiki/NAT64) для использования сетевых ресурсов имеющих только IPv4 адрес
* Необходимость запуска с правами root
* [Теговое](agents.md#tags) выражение ограничивающее множество хостов кластера Sandbox на которых может исполняться задача

В зависимости от указанных требований Sandbox выберет подходящие [агенты](agents.md) и будет запускать задачи только на таких агентах.

## Теговое выражение { #client-tags }

[Теговое](agents.md#tags) выражение, заданное в требованиях задачи, не может определять подмножество хостов для исполнения задачи в отрыве от других требований.
Поэтому при постановке задачи в очередь оно автоматически корректируются в соответствии с другими требованиями. Итоговое выражение сохраняется в аудите задачи (вкладка History на странице задачи).

Список автоматических корректировок:

* Если задача привилегированная, добавляется `& ~MULTISLOT`
* Если в требованиях задачи указаны `porto_layers`, добавляется тег `& PORTOD`,
    при этом если в выражении есть тег `LXC`, то он заменяется на `& (LXC | PORTOD)`
* Если в теговом выражении отсутствует тег `PORTOD`, добавляется `& LXC`
* Для задач с требованиями, подходящими для исполнения на мультислотах, добавляется `& (MULTISLOT | ~LINUX)`, что означает возможность исполнения на мультислотах (только Linux) или на платформах отличных от Linux
* Для задач с требованиями, не подходящими для исполнения на мультислотах, добавляется один из тегов количества ядер `CORES*`

## Приоритет задачи { #priorities }

У каждой запускаемой задачи есть **приоритет**, который определяет как быстро задача будет назначена на агент. Существует 3 основных приоритета (класса) задач:

1. **USER** (самый высокий приоритет) - задачи созданные пользователем через интерфейс.
  Предполагается, что вручную создаются только срочные задачи (например, выкатка исправлений). Поэтому такие задачи обрабатываются в первую очередь.
2. **SERVICE** - регулярно запускающиеся задачи, время исполнения которых критично, например, проверка пулл-реквеста.
3. **BACKGROUND** (самый низкий приоритет) - остальные задачи, время исполнения которых некритично.

Чтобы сортировать задачи внутри класса, можно указывать подкласс:

1. **HIGH**
2. **NORMAL**
3. **LOW**

Таким образом пара **USER:HIGH** - самый высокий приоритет, а **BACKGROUND:LOW**  - самый низкий приоритет.

{% note warning %}

Приоритеты задач имеют значение только в пределах [вычислительной квоты](quota.md) в которой они запускаются. Т.е. задача с более высоким приоритетом может стоять в очереди ниже чем задача с более низким приоритетом, но запущенная от группы с большим соотношением выделенной и потраченной квоты.

{% endnote %}

## Время жизни задачи { #ttl }

У каждой задачи можно задать **время жизни** (time to kill), т.е. максимальное время выполнения кода, после которого задача будет остановлена. Время жизни задачи по-умолчанию - **3 часа**. По-умолчанию всем процессам задачи при остановке отправляется [сигнал](https://en.wikipedia.org/wiki/Signal_(IPC)) SIGKILL. В коде задачи можно реализовать специальный метод, позволяющий правильно (gracefully) остановить все процессы перед завершением задачи.

## Иерархия задач { #hierarchy }

![Иерархия задач](img/task-hierarchy.png "Иерархия задач")

Существуют сценарии, когда невозможно выполнить все необходимые действия в одной задаче, например:

1. Задача порождает множество параллельных вычислительных потоков, которые "не помещаются" на один агент.
2. Требуется выполнить одно и то же действие (например, компиляцию исходного кода) на разных платформах.

Sandbox позволяет организовать **иерархию задач**, когда **основная задача** (parent task) порождает **подзадачи** (child tasks) и дожидается их выполнения.

## Запуск/старт задачи { #launch-task }

Задачу в Sandbox можно запустить пятью способами:

{% note info %}

Запускать, перезапускать и делать релизы задач может только их пользователь указанный в поле `author` или, если `author` — робот, владельцы и пользователи этого робота. Чтобы использовать робота, он должен быть привязан как ресурс к [ABC](https://abc.yandex-team.ru/) сервису. Пользователь должен [иметь](https://wiki.yandex-team.ru/intranet/abc/features/robots/) роль «Управляющий роботами» или «Пользователь роботов» в данном сервисе. Список доступных роботов синхронизируется раз в 10 минут.
Если вам нужно запустить задачу на которую у вас нет прав - ее можно склонировать.

{% endnote %}

### Способ 1: Создать задачу "с нуля" { #new-task }

1. Нажмите **Create > Task**, введите [тип задачи](tasks.md#type) и нажмите **Create**:

    ![Создание задачи с нуля](img/task-create-new.png "Создание задачи с нуля")

2. Укажите [группу](groups.md), от которой будет запускаться задача, ее описание, время жизни и приоритет:

    ![Конфигурация задачи](img/task-configuration.png "Конфигурация задачи")

3. Укажите настройки [уведомления](tasks.md#notifications) о прохождении задачи и [входные параметры](tasks.md#input-parameters) задачи:

    ![Параметры уведомления задачи](img/task-notification.png "Параметры уведомления задачи")

4. Нажмите кнопку **▶** (запустить):

    ![Кнопки запуска и клонирования задач](img/task-buttons.png "Кнопки запуска и клонирования задач")

### Способ 2: Клонировать существующую задачу { #clone-task }

Основное отличие от первого способа состоит в том, что при клонировании копируются настройки исходной задачи. Клонирование может быть удобно, если требуется перезапустить задачу с тем же самым набором параметров или поменять значение нескольких параметров из множества.

{% note info %}

При клонировании задачи не копируются некоторые требования:
запуска в привилегированном режиме (от root), ramdrive, семафоры.
Также не копируются параметры задачи, для которых это явно указано (`do_not_copy=True`).

{% endnote %}

1. Найдите и откройте существующую задачу.
2. Нажмите кнопку **❐** (клонировать).
3. Если требуется, поправьте настройки новой задачи.
4. Нажмите на кнопку **▶**.

### Способ 3: Запуск задачи по расписанию { #schedule-task }

В некоторых случаях требуется запускать задачу по расписанию.
В Sandbox запуск по расписанию выполняет отдельный объект - [**планировщик**](schedulers.md) (scheduler).

Для создания планировщика:

1. Нажмите **Create > Scheduler**, введите [тип задачи](tasks.md#type) и нажмите **Create**:

    ![Создание планировщика](img/task-scheduler.png "Создание планировщика")

2. Заполнить настройки и параметры, аналогично тому, как это делалось для задач.
3. Заполнить [параметры](schedulers.md#parameters) запуска по расписанию:

    ![Настройки запуска по расписанию](img/task-scheduler-settings.png "Настройки запуска по расписанию")

4. Нажать кнопку **▶** (run once) для однократного ручного запуска задачи
     или **↻** (schedule) для включения запуска по указанному расписанию.

Полный список планировщиков можно посмотреть на странице [Schedulers](https://sandbox.yandex-team.ru/schedulers):

![Список планировщиков](img/task-scheduler-list.png "Список планировщиков")

Больше информации о работе и статусах планировщиков смотрите на странице [Планировщики и запуск по расписанию](schedulers.md).

### Способ 4: Запуск задачи через API { #create-task-api }

Запустить задачу можно также через [REST API](https://sandbox.yandex-team.ru/media/swagger-ui/index.html#/batch).

### Способ 5: Запуск задачи через SDK { #create-task-sdk }
Задачу возможно запустить из другой задачи, используя [SDK](dev/subtask.md).

## Логи { #logs }

Во время выполнения задачи или после ее завершения вы можете смотреть различные логи. Посмотреть логи можно на странице задачи:

![Как открыть логи](img/task-logs.png "Как открыть логи")

Если открыть логи, то вы увидите примерно такой список файлов:

![Список лог-файлов](img/task-logs-files.png "Список лог-файлов")

Если задача реентерабельная (запускается несколько раз), то на каждый её запуск будет создана директория `log1`, `log2` и т.д.

Каждая задача может использовать неограниченное число лог-файлов с произвольным именем. Можно раскладывать лог-файлы по каталогам. Существует набор стандартных лог-файлов, создаваемых Sandbox:

Файл | Назначение
:--- | :---
**agentr.log** | Лог специального процесса agentr, постоянно работающего на хосте и отвечающего за работу с ресурсами задачи. В него смотрят, если в основных логах есть связанные с этим ошибки.
**atop.out** | Данные о потреблении процессора, памяти, дисков и других ресурсов задачей во время её работы в формате программы [atop](https://www.atoptool.nl/). Может использоваться для анализа потребления ресурсов задачей.
**common.log** | Логи запуска задачи уровня INFO и выше.
**debug.log** | Логи запуска задачи уровня DEBUG и выше. Включает в себя содержимое **common.log**. Могут использоваться при отладке выполнения задачи.
**disk_usage.yaml** | Содержит описание всех файлов, которые остались после работы задачи. **Данные сохраняются, когда задача завершилась. Если скачать файл во время работы задачи, вы не сможете его прочитать.**
**executor.err** | Содержимое стандартного потока ошибок (stderr) задачи.
**executor.out** | Содержимое стандартного потока вывода (stdout) задачи.
**peak_disk_usage.yaml** | То же самое, что и **disk_usage.yaml**, но в момент, когда задача занимала максимально возможное место на диске.

### atop.out { #atop-log }

Файл `atop.out` можно открыть при помощи такой команды:
```bash
$ atop -r atop.out
```

Если задача исполнялась не на Ubuntu Precise, то бинарник `atop` можно найти среди
[ресурсов типа SANDBOX_ATOP_BINARY](https://sandbox.yandex-team.ru/resources?owner=SANDBOX&type=SANDBOX_ATOP_BINARY&hidden=true&limit=20&attrs=%7B%22released%22%3A%22stable%22%7D).
Если задача исполнялась на Ubuntu Precise, то надо использовать более старую версию бинарника [atop](https://sandbox.yandex-team.ru/resource/1600378796/view).

## Уведомления { #notifications }

[Подробное описание уведомлений](dev/notification.md).
Sandbox позволяет отправлять уведомления о состоянии выполняемых задач. Отправить уведомление можно несколькими способами:

1. **По электронной почте.** Работает только для адресов **@yandex-team.ru**.
    Можно указывать e-mail адреса или логины сотрудников, почтовые рассылки, группы Sandbox.
2. **В Telegram.** Работает только для учетных записей Telegram, привязанных на [Staff](https://staff.yandex-team.ru/).
    Можно указывать группы, логины на Staff, логины в Telegram. При указании группы сообщение отправляет лично каждому участнику группы.
    Для того чтобы начать получать уведомления, необходимо один раз зарегистрироваться – написать произвольное сообщение роботу [@yasandbot](https://t.me/yasandbot).
3. **В [Q](https://q.yandex-team.ru/).**
    Для того чтобы получать личные сообщения, необходимо один раз отправить роботу [@robot-sandbox](https://staff.yandex-team.ru/robot-sandbox) сообщение `/sandbox_subscribe_user`.
    Для отправки сообщения группе нужно добавить робота в ваш чат и в настройках группы указать `Messenger chat id` равным `chat_id` чата, в которого вы добавили робота.
4. **В juggler.**
    Sandbox может отправлять сырые данные (OK, WARN, CRIT) на изменение статуса задачи или планировщика
    в заданную пользователем проверку в формате `host={user.host}&service={user_service}`.

Существует возможность отслеживания конкретных задач через Telegram или Q.
Для этого нужно отправить сообщение вида `/track task_id status1 status2`
роботу [@yasandbot](https://t.me/yasandbot) в Telegram или пользователю [@robot-sandbox](https://staff.yandex-team.ru/robot-sandbox) в Q.
Здесь `task_id` - идентификатор отслеживаемой задачи, а `status1, status2, ...` - состояния, для которых нужно отослать уведомления.

Если не указать ни одного состояния, будет применен набор по умолчанию.
С помощью этой функциональности нельзя отследить переход задачи в состояния, связанные с релизами.
