# Шаблоны

Шаблон - это объект с уникальным именем, представляющий собой частично или полностью заполненную sdk2 задачу, имеющий дополнительные возможности.

[API для шаблонов](https://sandbox.yandex-team.ru/media/swagger-ui/index.html#/template)

## Основные параметры шаблона {#template_parameters}

[API для получения cписка шаблонов](https://sandbox.yandex-team.ru/media/swagger-ui/index.html#/template/template_list_get)

[API для получения шаблона](https://sandbox.yandex-team.ru/media/swagger-ui/index.html#/template/template_get)

Шаблон имеет свои параметры и параметры задачи, которую он шаблонизирует. Параметры шаблона:
* alias: уникальное имя шаблона, может содержать цифры, английские буквы в любом регистре и символ '_'
* author: логин пользователя, создавшего шаблон
* status: статус шаблона, может быть READY и DELETED
* description: описание шаблона
* shared_with: список пользователей и Sandbox-групп, которые могут редактировать шаблон
* time: содержит подполя created и updated - время создания и обновления шаблона
* task: информация о шаблонизируемой задаче

Task содержит подполя **requirements** и **parameters**, где второе разделяется на **common** и **input**. Это требования задачи, параметры, которые есть у всех задач, и кастомные параметры соответственнно.

Каждое требование или параметр (для удобства, далее в это разделе просто параметр), содержит **value** и **meta** - значение параметра и информация о параметре соответственно.

Информация о параметре состоит из полей:
* hide: при значении **True** поле не отображается в UI
* default_from_code: значение **True** означает, что при создании задачи из шаблона для этого параметра будет выставлено дефолтное значение из кода
* filter: для параметров ресурсного типа можно задать фильтр для поиска ресурса. При создании задачи из шаблона будет для выбора значения этого параметра будет применен этот фильтр и взят один ресурс


# Основные параметры в UI

![Список параметров шаблона](img/templates-view.png "Список параметров шаблона")
На странице шаблона есть 5 вкладок в главном окне:
* Template configuration: тут имя шаблона, описание и список людей, которые могут его редактировать
* Task configuration: параметры, которые являются общими для всех задач. На странице задач они всегда отображены. Это owner задачи, описание задачи, требуемое место на диске, время жизни и приоритет
* Notification parameters: параметры уведомлений. Они аналогичны настройкам уведомлений из задачи, но содержат два дополнительных шаблона получателя: \<owner> и \<author>. Это означает, что при запуске задачи из шаблона \<owner> и \<author> заменятся на owner'а и author'а задачи соответственно
* Advanced: общие параметры задачи, отображающиеся в задаче под вкладкой Advanced
* Custom parameters: пользовательский параметры задачи

![Параметр шаблона](img/templates-parameter-view.png "Параметр шаблона")

При раскрытии любой из этих вкладок, кроме первой, показываются 3 колонки:
* Описание параметра
* Значение параметра, заданное в шаблоне
* Дефолтное значение параметра, заданое в коде задач

При нажатии кнопки Show hidden покажутся все параметры, включая скрытые, а сама кнопка заменится на Hide hidden. При нажатии кнопки Hide hidden скрытые параметры скрываются.

![Создание задачи из шаблона](img/templates-task-creation.png "Создание задачи из шаблона")

Правее от имени шаблона есть кнопки:
* Launch new task: при нажатии показывает форму для выбора owner'а, от чьего имени будет запущена задача. После выбора создает и запускает задачу
* Create new task: при нажатии создает задачу в статусе DRAFT
* ... - открывает меню дополнительных действий с шаблоном. В нем есть Delete - удалить шаблон

![Фильтр шаблонов](img/templates-filter.png "Фильтр шаблонов")
Чтобы добавить шаблон в избранные, нужно нажать на звездочку справа от статуса шаблона. Тогда на странице списка шаблонов этот шаблон будет отображаться в My. При нажатии на All будут отображаться все шаблоны, которые можно отфильтровать.

## Создание шаблона { #creation }

[API для создания шаблона](https://sandbox.yandex-team.ru/media/swagger-ui/index.html#/template/template_list_post)

Новый шаблон можно создать тремя способами:
* Создать новый пустой шаблон, выбрав тип задачи и ресурс с бинарными задачами. В UI за это отвечает кнопка **Сreate**, в выпадающем окне нужно выбрать **Template**. В API данный способ определяется наличием типа задачи в POST методе. Можно указать **tasks_resource** или **tasks_resource_filter** для создания шаблона из выбранного ресурса с бинарными задачами или по фильтру.
* Склонировать уже существующий шаблон. Для этого в API нужно указать **template_alias**.
* Создать шаблон из задачи. При этом создастся шаблон, в котором все параметры будут заполнены из параметров задачи. Для этого в UI нужно нажать кнопку на странице задачи **Clone as template**. В API нужно указать **task_id**.
![Создание шаблона из задачи](img/templates-from-task-creation.png "Создание шаблона из задачи")

## Обновление шаблона { #update }

[API для обновления шаблона](https://sandbox.yandex-team.ru/media/swagger-ui/index.html#/template/template_put)

Метаданные о задаче шаблона хранятся в базе данных, поэтому при изменении кода задач параметры задачи шаблона сами не изменятся (не добавятся, не удалятся и не изменятся). При обновлении шаблона из UI или API применятся свежие данные о задаче из кода задач и параметры задачи шаблона обновятся. Пустой запрос на обновление шаблона только обновит метаданные о параметрах задачи шаблона.

* В UI для обновления параметра нужно нажать на карандашик возле его значения
* Для скрытия параметра нужно нажать на глаз, появляющийся справа при наведении на параметр
* Для сброса параметра в дефолтное значение нужно при редактировании параметра нажать на стрелочку сброса справа от значения параметра.
* Если оставить параметр-строку пустым, то его значение будет пустой строкой

## Общие свойства { #properties }

* Создать задачу из шаблона может любой пользователь
* Редактировать шаблон могут только пользователи, определенные в параметре шаблона shared_with
* Можно создать фильтр для ресурса с кодом задач, тогда сам шаблон и созданные из него задачи будут использовать этот фильтр, например, для выбора последнего зарелиженного ресурса
* У задачи есть поле template_alias, по которому можно узнать, из какого шаблона она создана
* Шаблон живет отдельно от кода задач, используя его только при создании и обновлении
