import abc

from sandbox.common import rest as common_rest
from sandbox.common import patterns as common_patterns

import sandbox.common.types.misc as ctm

import six


@six.add_metaclass(abc.ABCMeta)
class ExecutableBase(object):
    def __init__(self, task_id=None, logdir=None, agentr=None, task=None):
        self.subsequent = bool(task)
        # Previous task status is passed as an argument to these hooks:
        # on_finish, on_failure, on_success, on_break, on_timeout, on_wait
        # This field (as well as self.task.status) is only modified in self.set_status() method.
        self.prev_status = None

        # Target status is a "result" of execution, e.i. which status task should be switched to.
        # For example ExecuteTask can return WAIT_TASK, but actual task status at that point will be EXECUTING.
        # TerminateTask will perfrom switching "EXECUTING -> STOPPING -> WAIT_TASK" and return WAIT_TASK.
        self.target_status = None

    @common_patterns.classproperty
    def rest_client(cls):
        cls.rest_client = common_rest.Client(component=ctm.Component.EXECUTOR)
        return cls.rest_client

    @abc.abstractmethod
    def execute(self):
        pass
