import os

SANDBOX_DIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))  # noqa

# Container's directory with sandbox-specific hooks to be executed with root privileges.
ROOT_HOOKS_ROOT = "/etc/sandbox"
# An executable, which will be invoked if exists before task start with root privileges.
# Task's working directory will be passed as first arguments. Exit code will be ignored, only warning logged.
ON_TASK_START_ROOT_HOOK = ROOT_HOOKS_ROOT + "/on_task_start"
# An executable, which will be invoked if exists before task stop with root privileges.
# No arguments will be passed to it. Exit code will be ignored, only warning logged.
ON_TASK_STOP_ROOT_HOOK = ROOT_HOOKS_ROOT + "/on_task_stop"
# Hooks execution timeout. Exit with error if expired
ROOT_HOOKS_TIMEOUT = 5 * 60
