#!/skynet/python/bin/python
# This script pings up to 3 of sandbox servers and returns 1 if none is reachable.

import random
import subprocess as sp

import utils


SERVICE_NAME = "fastbone_sandbox"
HOST_TEMPLATE = "fb-sandbox-server{:02}.search.yandex.net"
SERVERS_INDEXES = [
    range(1, 6),    # SAS
    # range(6, 11),   # MAN
    range(11, 16),  # VLA
    range(16, 26),  # IVA
]
LARGE_MTU = 8860
REGULAR_MTU = 1450


def ping(host_index):
    host = HOST_TEMPLATE.format(host_index)
    ping_cmd = "ping6 -qns{} -c3 -w20 {}".format(LARGE_MTU, host)
    ping_proc = sp.Popen(ping_cmd.split(), stdout=sp.PIPE, stderr=sp.PIPE)
    out_big_ping, error = ping_proc.communicate()
    if ping_proc.returncode != 0:
        ping_cmd = "ping6 -qns{} -c3 -w10 {}".format(REGULAR_MTU, host)
        ping_proc = sp.Popen(ping_cmd.split(), stdout=sp.PIPE, stderr=sp.PIPE)
        out, error = ping_proc.communicate()
        if ping_proc.returncode == 0:
            return "Can't ping {} with big packets: {}".format(host, out_big_ping)

        return "Can't ping {}: {}".format(host, (error or out).strip())


def main():
    error_message = None
    for host_index in [random.choice(dc_indexes) for dc_indexes in SERVERS_INDEXES]:
        error_message = ping(host_index)
        if not error_message:
            break
    code = utils.STATUS_CRIT if error_message else utils.STATUS_OK
    utils.say(SERVICE_NAME, code, error_message or "OK")


if __name__ == "__main__":
    main()
