#!/skynet/python/bin/python

import pymongo
import datetime

import utils


SERVICE_NAME = "sandbox_assigned_task_age"
ASSIGNED_THRESHOLD = 60  # minutes
ASSIGNED_THRESHOLD_TOO_LONG = 6 * 60  # minutes
MAX_HANGING_TASKS_AMOUNT = 5
HOST = "localhost"
PORT = 22222


def main():
    client = pymongo.MongoClient(HOST, PORT)
    db = client["sandbox"]

    tasks = list(db.task.find({"exc.st": "ASSIGNED"}, ["_id", "time"], sort=[("time.up", pymongo.ASCENDING)]))

    if tasks:
        now = datetime.datetime.utcnow()
        threshold = datetime.timedelta(minutes=ASSIGNED_THRESHOLD)
        hanging_tasks = filter(lambda t: now - t["time"]["up"] > threshold, tasks)

        if len(hanging_tasks) >= MAX_HANGING_TASKS_AMOUNT:
            description = "{} tasks are hanging {}+ mins in ASSIGNED. Ids: {}".format(
                len(hanging_tasks),
                ASSIGNED_THRESHOLD,
                list(t["_id"] for t in hanging_tasks)
            )
            utils.say(SERVICE_NAME, utils.STATUS_CRIT, description, die=True)

        if hanging_tasks:
            worst = hanging_tasks[0]
            also_hanging = hanging_tasks[1:]
            delta = now - worst["time"]["up"]
            description = "Task {} is in ASSIGNED for {}.{}".format(
                worst["_id"],
                __chop_microseconds(delta),
                " Check also hanging {}".format([_["_id"] for _ in also_hanging]) if len(also_hanging) else ""
            )
            if delta > datetime.timedelta(minutes=ASSIGNED_THRESHOLD_TOO_LONG):
                utils.say(SERVICE_NAME, utils.STATUS_CRIT, description, die=True)
            elif delta > datetime.timedelta(minutes=ASSIGNED_THRESHOLD):
                utils.say(SERVICE_NAME, utils.STATUS_WARN, description, die=True)

    utils.say(SERVICE_NAME, utils.STATUS_OK, "OK")


def __chop_microseconds(delta):
    return delta - datetime.timedelta(microseconds=delta.microseconds)


if __name__ == "__main__":
    main()
