#!/skynet/python/bin/python

import pymongo
import datetime

import utils


SERVICE_NAME = "sandbox_enqueuing_task_age"
ENQUEUING_THRESHOLD = 5  # minutes
HOST = "localhost"
PORT = 22222


def main():
    client = pymongo.MongoClient(HOST, PORT)
    db = client["sandbox"]

    tasks = list(db.task.find({"exc.st": "ENQUEUING"}, ["_id", "time"], sort=[("time.up", 1)]))
    if not tasks:
        utils.say(SERVICE_NAME, utils.STATUS_OK, "OK", die=True)
        return

    delta = datetime.datetime.utcnow() - tasks[-1]["time"]["up"]
    if delta > datetime.timedelta(minutes=ENQUEUING_THRESHOLD):
        utils.say(SERVICE_NAME, utils.STATUS_CRIT,
                  "Task {}'s time in ENQUEUING: {}".format(tasks[-1]["_id"], delta),
                  die=True)

    utils.say(SERVICE_NAME, utils.STATUS_OK, "OK")


if __name__ == "__main__":
    main()
