#!/skynet/python/bin/python

import pymongo

import utils


SERVICE_NAME = "sandbox_executing_tasks_yabs_ytstat"
UNDERUTILIZATION_THRESHOLD = 200  # as seen on graphs
HOST = "localhost"
PORT = 22222


def main():
    client = pymongo.MongoClient(HOST, PORT)
    db = client["sandbox"]

    def count(status):
        return db.task.find({"exc.st": status, "owner": "YABS-YTSTAT"}).count()

    # this implies that:
    # a) there should be as few tasks in queue as possible, otherwise Sandbox can't keep the pace
    # b) there won't be false positives during nights, when the load is low
    executing, enqueued = map(count, ("EXECUTING", "ENQUEUED"))
    if executing - enqueued >= UNDERUTILIZATION_THRESHOLD:
        utils.say(SERVICE_NAME, utils.STATUS_OK,
                  "{} tasks executing, {} in queue".format(executing, enqueued),
                  die=True)

    utils.say(
        SERVICE_NAME,
        utils.STATUS_CRIT,
        "{} tasks of YABS-YTSTAT are executing, {} in queue (difference threshold: {})".format(
            executing, enqueued, UNDERUTILIZATION_THRESHOLD
        )
    )


if __name__ == "__main__":
    main()
