#!/skynet/python/bin/python
import socket

import yaml

import utils

SERVICE_NAME_TEMPLATE = "mongodbs-{}"

SHARDS_RANGE = (37001, 37002)
SHARDS_EXTRA_RANGE = (37001, 37002, 37003, 37004)
SAS_HOSTS = {
    "sandbox-server01.search.yandex.net",
    "sandbox-server02.search.yandex.net",
    "sandbox-server03.search.yandex.net",
    "sandbox-server04.search.yandex.net",
    "sandbox-server05.search.yandex.net"
}
VLA_HOSTS = {
    "sandbox-server11.search.yandex.net",
    "sandbox-server12.search.yandex.net",
    "sandbox-server13.search.yandex.net",
    "sandbox-server14.search.yandex.net",
    "sandbox-server15.search.yandex.net"
}
CONFIG_PATH_TEMPLATE = "/etc/mongod_{}.conf"


def main():
    hostname = socket.gethostname()
    shards_range = SHARDS_EXTRA_RANGE if hostname in SAS_HOSTS or hostname in VLA_HOSTS else SHARDS_RANGE
    for identifier in shards_range:
        service_name = SERVICE_NAME_TEMPLATE.format(identifier)

        try:
            with open(CONFIG_PATH_TEMPLATE.format(identifier), "r") as fd:
                config = yaml.safe_load(fd)
                port = config["net"]["port"]
        except (IOError, OSError, KeyError) as exc:
            utils.say(service_name, utils.STATUS_CRIT, "Cannot determine port: {}".format(exc), die=True)

        try:
            state = utils.check_replica_state("localhost", port)
            code = utils.replica_health(state)
            message = "mongod_{} is {}".format(port, utils.REPLICA_STATES[state])
        except Exception as exc:
            code = 2
            message = "mongod_{} check failed: {}".format(port, exc)
        utils.say(service_name, code, message)


if __name__ == "__main__":
    main()
