#!/skynet/python/bin/python

import io
import socket
import requests

import utils

SERVICE_NAME = "sandbox_zookeeper"
CONDUCTOR_URL = "https://c.yandex-team.ru/api/tag2hosts"
CONDUCTOR_TAG = "sandbox_zk"
ZK_PORT = 2181
ZK_ELECTION_PORT = 3888
ZK_MODE_PREFIX = "Mode: "
OK_MODES = ("leader", "follower")


def main():
    resp = requests.get("/".join((CONDUCTOR_URL, CONDUCTOR_TAG)))
    if resp.ok:
        hosts = resp.text.splitlines()
        code = 0
        errors = []
        for host in hosts:
            try:
                port = ZK_PORT
                s = socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
                s.connect((host, ZK_PORT))
                s.send("srvr\n")
                resp = io.BytesIO()
                chunk = " "
                while chunk:
                    chunk = s.recv(4096)
                    resp.write(chunk)
                mode = next(
                    iter(filter(lambda _: _.startswith(ZK_MODE_PREFIX), resp.getvalue().split("\n"))),
                    ""
                )[len(ZK_MODE_PREFIX):]
                if mode not in OK_MODES:
                    code = 2
                    if not mode:
                        raw_resp = "RESPONSE RAW:" + resp.getvalue()
                    errors.append("{}: {}".format(host, mode or raw_resp))
                port = ZK_ELECTION_PORT
                s = socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
                s.connect((host, ZK_ELECTION_PORT))
            except socket.error as ex:
                errors.append("{}:{} - {}".format(host, port, ex))
                code = 2
        if code:
            message = "; ".join(errors)
        else:
            message = "All ZK nodes are ok"
    else:
        code = 2
        message = "Conductor responded with code {}".format(resp.status_code)

    utils.say(SERVICE_NAME, code, message)


if __name__ == "__main__":
    main()
