#!/skynet/python/bin/python

import pymongo
import datetime as dt

import utils


SERVICE_NAME = "step_unprocessed_events"
MAX_PROCESSING_DELAY = 30  # minutes
HOST = "localhost"
PORT = 22222


def main():
    client = pymongo.MongoClient(HOST, PORT)
    db = client["events2"]

    unprocessed_events_count = db.event.find(
        {
            "state": "PROCESSING",
            "time_created": {"$lt": dt.datetime.now() - dt.timedelta(minutes=MAX_PROCESSING_DELAY)}
        }
    ).count()

    if unprocessed_events_count:
        utils.say(
            SERVICE_NAME,
            utils.STATUS_CRIT,
            "{} unprocessed events older {} minutes".format(unprocessed_events_count, MAX_PROCESSING_DELAY),
            die=True
        )

    utils.say(SERVICE_NAME, utils.STATUS_OK, "OK")


if __name__ == "__main__":
    main()
