# -*- coding: utf-8 -*-
from sandbox import sandboxsdk


PARAM_GROUP = 'Shardmaps and binary'


class ReferenceShardmap(sandboxsdk.parameters.ResourceSelector):
    name = 'reference_shardmap'
    description = 'Reference shardmap'
    group = PARAM_GROUP
    required = True


class ReferenceBinary(sandboxsdk.parameters.ResourceSelector):
    name = 'reference_binary'
    description = 'Reference binary'
    group = PARAM_GROUP
    required = True


class TestShardmap(sandboxsdk.parameters.ResourceSelector):
    name = 'test_shardmap'
    description = 'Test shardmap'
    group = PARAM_GROUP
    required = True


class TestBinary(sandboxsdk.parameters.ResourceSelector):
    name = 'test_binary'
    description = 'Test binary'
    group = PARAM_GROUP
    required = True


class StartrekTask(sandboxsdk.parameters.SandboxStringParameter):
    name = 'startrek_task'
    description = 'Startek task'
    required = False


class PushData(sandboxsdk.parameters.SandboxBoolParameter):
    name = 'push_data'
    description = 'Push perf data to YT'
    default_value = False


class LaunchType(sandboxsdk.parameters.SandboxSelectParameter):
    name = 'launch_type'
    description = 'Launch type'
    required = True
    default_value = 'DB'
    choices = [('Release Machine', 'RM'),
               ('Database', 'DB')]
