# -*- coding: utf-8 -*-
from sandbox import sandboxsdk
import requests
import re
from sandbox import common
from sandbox.projects.common.apihelpers import get_last_resource_with_attrs


LOAD_RGX = re.compile(r'addrs_[a-z]+_l\d+')


def get_nanny_cache():
    resourse = get_last_resource_with_attrs('ADDRS_NANNY_CACHE', all_attrs=True, attrs={})
    data = requests.get(resourse.url).json()
    return data


class Action(sandboxsdk.parameters.SandboxStringParameter):
    name = 'action'
    description = 'Action'
    required = True
    choices = [('Make production', 'make_production'),
               ('Copy service', 'copy_service'),
               ('Change Sandbox resource', 'sandbox_resource'),
               ('Change GenCfg topology', 'change_topology')]


class ActivateAfterChanging(sandboxsdk.parameters.SandboxBoolParameter):
    name = 'activate'
    description = 'Activate service after changing its attributes'
    default_value = True


class ForceNewSnapshot(sandboxsdk.parameters.SandboxBoolParameter):
    name = 'force_snapshot'
    description = 'Force new snapshot creation on zero-diff'
    default_value = True


class Stand(sandboxsdk.parameters.SandboxStringParameter):
    name = 'stand'
    description = 'Which load stand use'
    required = True

    @common.utils.singleton_classproperty
    def choices(cls):
        data = get_nanny_cache()
        stands = data.get('stands')
        stands = sorted(stands)
        return [(stand, stand) for stand in stands]


class Service(sandboxsdk.parameters.SandboxSelectParameter):
    name = 'service'
    description = 'Copy configuration from existing service'
    required = True

    @common.utils.singleton_classproperty
    def choices(cls):
        data = get_nanny_cache()
        services = data.get('services')
        services = sorted(services)
        return [(service, service) for service in services if not LOAD_RGX.match(service)]


class SandboxResource(sandboxsdk.parameters.ListRepeater, sandboxsdk.parameters.SandboxStringParameter):
    name = 'nanny_resource'
    description = 'Sandbox resource'
    required = True


class DestinationService(sandboxsdk.parameters.SandboxSelectParameter):
    name = 'destination_service'
    description = 'Destination service'
    required = True

    @common.utils.singleton_classproperty
    def choices(cls):
        data = get_nanny_cache()
        services = data.get('services')
        services = sorted(services)
        # return [(service, service) for service in services if LOAD_RGX.match(service)]
        return [(service, service) for service in services]


class Topology(sandboxsdk.parameters.SandboxStringParameter):
    name = 'topology'
    description = 'GenCfg topology'
    required = False


class TopologyAction(sandboxsdk.parameters.SandboxSelectParameter):
    name = 'topology_action'
    description = 'Action for topology'
    required = False
    choices = [('Add', 'add_topology'),
               ('Delete', 'delete_topology')]


Action.sub_fields = {'make_production':          [Stand.name,
                                                  ActivateAfterChanging.name,
                                                  ForceNewSnapshot.name],
                     'copy_service':             [Service.name,
                                                  DestinationService.name,
                                                  ActivateAfterChanging.name,
                                                  ForceNewSnapshot.name],
                     'sandbox_resource':         [DestinationService.name,
                                                  SandboxResource.name,
                                                  ActivateAfterChanging.name],
                     'change_topology':          [DestinationService.name,
                                                  TopologyAction.name,
                                                  Topology.name]}
