# -*- coding: utf-8 -*-

import logging
import os

import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.sandboxsdk.parameters import LastReleasedResource

from sandbox.projects.common import profiling as search_profiling
from sandbox.projects.common.search import performance as search_performance

from sandbox.projects.common.geosearch import task as addrs_task


DOLBILKA_SPACE = 4500 * 10
RESERVED_SPACE = 30000


class PlanParameter(LastReleasedResource):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    resource_type = ['BASESEARCH_PLAN']


class RunProfilerParameter(SandboxBoolParameter):
    name = 'run_profiler'
    description = 'Run profiler'
    default_value = False


class AddrsTestBasesearchPerformance(search_performance.OldShootingTask,
                                     search_profiling.ProfilingTask,
                                     addrs_task.AddrsBasesearchTask):

    type = 'ADDRS_TEST_BASESEARCH_PERFORMANCE'

    required_ram = 100 << 10
    execution_space = DOLBILKA_SPACE + RESERVED_SPACE
    # client_tags = ctc.Tag.INTEL_E5_2650 & search_performance.OldShootingTask.client_tags
    client_tags = ctc.Tag.INTEL_E5_2650 & ctc.Tag.LINUX_PRECISE

    new_stats_types = (
        ("latency_0.5", "Latency, q50 (usec)", "{:0.2f}"),
        ("latency_0.95", "Latency, q95 (usec)", "{:0.2f}"),
        ("latency_0.99", "Latency, q99 (usec)", "{:0.2f}"),
        ("resp_size_quantile_0.5", "Response size median (bytes)", "{:0.1f}"),
        ("max_size", "Max response size (bytes)", "{:0.1f}"),
    )

    @property
    def footer(self):
        foot = []
        # tasks_foot = self._get_lunapark_tasks()
        tasks_foot = self.ctx.get('lunapark_url')
        profiling_foot = search_profiling.ProfilingTask.profiling_footer(self)
        if tasks_foot:
            foot.append({
                'helperName': 'Lunapark tasks',
                'content': tasks_foot
            })
        if profiling_foot:
            foot.append({
                'helperName': '',
                'content': profiling_foot
            })
        performance_foot = search_performance.OldShootingTask.footer.fget(self)
        foot.append({
            'helperName': '',
            'content': performance_foot
        })
        return foot

    shoot_input_parameter = \
        (PlanParameter,
         RunProfilerParameter) + \
        search_performance.OldShootingTask.shoot_input_parameters

    input_parameters = \
        shoot_input_parameter + \
        addrs_task.AddrsBasesearchTask.basesearch_common_parameters + \
        search_profiling.ProfilingTask.input_parameters

    def on_execute(self):
        logging.info('Initializing geobasesearch')
        geobasesearch = self._get_addrsbasesearch()
        self._init_virtualenv()
        self._profiling_init(geobasesearch, self.__get_perf_data_path())
        with geobasesearch:
            self._old_shoot(geobasesearch, self.ctx[PlanParameter.name])
        self._profiling_report(geobasesearch, self.__get_perf_data_path())
        self.ctx['lunapark_url'] = self._get_lunapark_tasks()

    def _get_queries_parameters(self):
        return PlanParameter

    def _get_lunapark_tasks(self):
        tasks = []
        for root, sub_dir, file_names in os.walk(self.path('./')):
            if 'fire.session' in root and 'lunapark' in root:
                tasks.extend(sub_dir)
        if not tasks:
            return ""
        url = ('https://lunapark.yandex-team.ru/compare/#jobs=%s'
               '&tab=test_data'
               '&mainjob=%s'
               '&helper=all'
               '&cases='
               '&plotGroup=additional'
               '&metricGroup='
               '&target=') % (','.join(tasks), list(tasks)[0])
        href = "<p><a href=%s>%s</a></p>" % (url, url)
        logging.info(href)
        return href or 'Link creation failed'

    def get_short_task_result(self):
        if not self.is_completed():
            return None
        if 'max_rps' in self.ctx:
            return '{:0.2f}'.format(self.ctx['max_rps'])

    def __get_perf_data_path(self, recreate=False):
        return self.abs_path('perf.data')


__Task__ = AddrsTestBasesearchPerformance
