# -*- coding: utf-8 -*-

save_schedule = '''
$places = (select id, ListFilter( Yson::ConvertTo(
        Yson::YPath(Yson::Parse(_object), '/integration'), List<Dict<String,Yson>>
    ),($x) -> {{ RETURN Yson::ConvertToString(Yson::Parse($x["source_name"])) == "geosearch"}})[0]["source_id"] as permalink from `//home/afisha/export/production/places`);

INSERT INTO `{schedule_dir}/{table}` WITH TRUNCATE
SELECT
    schedule.schedule as schedule,
    schedule.schedule_info as schedule_info,
    schedule.event as info,
    schedule.place as place,
    schedule.`place.city.id` as place_city_id,
    schedule.`event.type.code` as event_type_code,
    schedule.`event.id` as event_id,
    place.id as place_id,
    place.permalink as permalink
    FROM
        `{schedule_log}` as schedule
        LEFT JOIN $places as place
        ON (place.id == schedule.`place.id`)
    WHERE permalink is not null;
'''

create_pushes = '''
use hahn;

$format = DateTime::Format("%Y-%m-%d %H:%M:%S %Z");

$py=@@
import cyson as yson
import datetime
import time

def getDateTime(info):
    d = yson.loads(info)
    return [row.get("datetime_utc") for row in d if row.get("datetime_utc")]

def getTimestamp(info, begin, end):
    d = [int(time.mktime(datetime.datetime.strptime(row, "%Y-%m-%dT%H:%M:%S").timetuple())) - time.timezone for row in getDateTime(info)]
    return [t for t in d if begin <= t and end >= t + 3600 and begin >= t - 40*60 and end <= t + 3*60*60]
@@;

$getDateTime = Python2::getDateTime(Callable<(Yson?)->List<String>>, $py);
$getTimestamp = Python2::getTimestamp(Callable<(Yson?, Int64?, Int64?)->List<Int64>>, $py);

insert into @table
with truncate
select
    schedule.schedule_info,
    schedule.permalink,
    schedule.place,
    schedule.info,
    schedule.schedule,
    schedule.event_type_code,
    schedule.event_id,
    $format(DateTime::FromSeconds(CAST($getTimestamp(schedule.schedule,org.`timestamp`, org.`timestamp`+org.duration_s)[0] as Uint32))) as event_start,
    $format(DateTime::FromSeconds(CAST(org.`timestamp` as Uint32))) as guest_come,
    $format(DateTime::FromSeconds(CAST(org.`timestamp`+org.duration_s as Uint32))) as guest_go_away,
    org.mmetric_devid,
    org.duration_s,
    Yson::ConvertTo(Yson::YPath(Yson::Parse(schedule.schedule_info), '/dates'), List<String>) as schedule_dates
    FROM
         `{export_dir}/{table}`  as org
        INNER JOIN `{schedule_dir}/{schedule_table}` as schedule
        ON ( CAST(Yson::ConvertToString(Yson::Parse(schedule.permalink)) as Int64) == org.permalink)
    where
        ListHasItems($getTimestamp(schedule.schedule,org.`timestamp`, org.`timestamp`+org.duration_s))
        AND Yson::ConvertToString(Yson::YPath(Yson::Parse(schedule.info),"/type/code")) IN AsList("theatre");
COMMIT;

$py=@@
import json
from datetime import datetime


def createPush(title, link, devid):
    push = \'\'\'
    {{
  "receiver" : [ "did:<did>" ],
  "ttl" : 86400,
  "data" : {{
    "push_id" : "afisha_review"
  }},
  "notification" : {{
    "title" : "Три толстяка. Эпизод 1. Восстание",
    "body" : "Хотите поделиться мыслями о постановке?",
    "link" : "https://afisha.yandex.ru/saint-petersburg/theatre_show/tri-tolstiaka-epizod-1-vosstanie?utm_source=yandex_search_app&utm_medium=polling#comments"
  }},
 "android_features" : {{
    "soundType" : 1,
    "style" : "system"
  }},
  "ios_features" : {{
    "soundType" : 1
  }},
  "project" : "afisha_review"
}}
 \'\'\'

    push = json.loads(push)

    push['notification']['title'] = title
    push['notification']['link'] = link
    push['receiver'] = ["did:{{}}".format(devid)]
    return json.dumps(push)
 @@;

 $createPush = Python2::createPush(Callable<(String?, String?, String?)->String>, $py);


 insert into `{push_dir}/{table}`
 WITH TRUNCATE
 SELECT *
 FROM(
     SELECT
        SOME(push) as push, did, SOME(title) as title, COUNT(*) as size
    from(
        SELECT $createPush(
            Yson::LookupString(`schedule.info`, "title"),
            Yson::LookupString(`schedule.info`, "url") || "?utm_source=yandex_search_app&utm_medium=polling#comments",
            `org.mmetric_devid`
        ) as push, `org.mmetric_devid` as did, Yson::LookupString(`schedule.info`, "title") as title
        FROM @table
        where `org.mmetric_devid` is not null
    )
    GROUP BY did, title
)
where size == 1;

insert into `{visit_dir}/{table}`
SELECT * FROM @table;
'''
