# coding: utf-8

import sandbox.sdk2 as sdk2
from sandbox.projects.Afisha.base import AfishaSandboxBaseTask


class AfishaTicketsBackendDeploy(AfishaSandboxBaseTask):

    BINARY_TASK_ATTR_TARGET = "Afisha/deploy/projects/AfishaTicketsBackendDeploy"
    RELEASE_TASK = "AFISHA_RELEASE_2"

    class Parameters(AfishaSandboxBaseTask.Parameters):
        version = sdk2.parameters.String("Version to deploy", required=True)
        allow_downgrade = sdk2.parameters.Bool("Allow downgrade", default=False)

    def deploy(self):
        subtasks = self.subtasks.get(self.RELEASE_TASK, [])
        if subtasks:
            return
        else:
            deploy_task = self.task(
                self.RELEASE_TASK,
                owner=self.Parameters.owner,
                priority=self.Parameters.priority,
                description="Releasing afisha-tickets-backend",
                component_name="afisha_tickets_backend",
                version=self.Parameters.version,
                flow="stable",
                target_state="COMMITTED",
                use_robot=False,
                allow_downgrade=self.Parameters.allow_downgrade)
        self.subtasks_run([deploy_task])

    def on_execute(self):
        self.deploy()
