# coding: utf-8
import os
import sandbox.sdk2 as sdk2
from time import time
from sandbox.projects.Afisha.base import AfishaSandboxBaseTask


class AfishaDtc(AfishaSandboxBaseTask):

    BINARY_TASK_ATTR_TARGET = 'Afisha/infra/AfishaDtc'

    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 1024  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(AfishaSandboxBaseTask.Parameters):
        kill_timeout = 120
        with sdk2.parameters.Group("Settings") as settings_block:
            configs = sdk2.parameters.List("Config names to process", required=True)
            secret = sdk2.parameters.YavSecret("Yav token", required=True)
            secret_key = sdk2.parameters.String("key in yav secret", required=True)

    def on_execute(self):
        from afisha.infra.libs.dtc import DowntimeCalculator
        os.environ["YAV_TOKEN"] = self.Parameters.secret.data()[self.Parameters.secret_key]
        end = time()
        for config_name in self.Parameters.configs:
            dtc = DowntimeCalculator.from_api(config_name)
            start = dtc.get_last_result_end()
            if start is None:
                start = end - 3600
            else:
                start = start + 1
            dtc.run(start, end)
            dtc.save_result()
