# coding: utf-8
import logging
import sandbox.sdk2 as sdk2
import sandbox.common.types.misc as ctm
from requests.exceptions import HTTPError
from sandbox.projects.Afisha.base import AfishaSandboxBaseTask


class AfishaPrRegister(AfishaSandboxBaseTask):

    BINARY_TASK_ATTR_TARGET = "Afisha/infra/AfishaPrRegister"

    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 1024  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(AfishaSandboxBaseTask.Parameters):
        kill_timeout = 120
        with sdk2.parameters.Group("Settings") as settings_block:
            component_name = sdk2.parameters.String("Component name", required=True)
            pr = sdk2.parameters.String("Pr id. Using only if no arcanum_review_id in Context")

    def setup(self):
        self._init_rc()

    @property
    def component(self):
        if getattr(self, "_component", None):
            return self._component
        if self.Context.component is not ctm.NotExists:
            self._component = self.rc.components.restore(**self.Context.component)
            return self._component
        self._component = self.rc.components.find(name=self.Parameters.component_name)[0]
        self.Context.component = self._component.to_dict()
        return self._component

    @property
    def pr_id(self):
        if self.Context.arcanum_review_id is ctm.NotExists:
            return self.Parameters.pr
        return str(self.Context.arcanum_review_id)

    def on_execute(self):
        if self.Context.arcanum_review_id is not ctm.NotExists:
            if self.Context.arcadia_patch is ctm.NotExists or not self.Context.arcadia_patch:
                logging.debug("arcanum_review_id defined, arcadia_patch not defined - skip")
                return
        self.setup()
        logging.debug("Registering pr %s for %s component", self.pr_id, self.component.name)
        pr = self.rc.prs.new(self.component.link, self.pr_id)
        try:
            pr.save()
        except HTTPError as error:
            if error.response.status_code != 409:
                raise
            logging.debug("Already registered")
