""" Settings and constants for release machine """
import sandbox.projects.release_machine.core.const as rm_const


RM_TESTENV_OWNERS = [
    "aarseniev",
    "maximus",
    "msurin",
    "antomus",
    "alexeyss",
    "zydins",
    "diana07"
]

STARTREK_FOLLOWERS = [
    "tipitina"
]

TRUNK_TASK_OWNER = "AFISHA"
COMPONENT_GROUP = "afisha"
STARTREK_QUEUE = "AFISHARELEASES"
TASK_NAMES = {
    "build": "AFISHA_BUILD_DOCKER",
    "release": "AFISHA_RELEASE",
    "release2": "AFISHA_RELEASE_2",
    "pr_release": "AFISHA_PR_RELEASE",
    "pr_register": "AFISHA_PR_REGISTER"
}
TASK_CI_REG_LOCATIONS = {
    "build": "projects/afisha/afisha_build_docker",
    "release": "projects/afisha/afisha_release",
    "release2": "projects/afisha/afisha_release_2",
    "pr_release": "projects/afisha/afisha_pr_release",
    "pr_register": "projects/afisha/afisha_pr_register"
}
RELEASE_RESOURCE = "AFISHA_TICKETS_BACKEND_BINARY"
RESTART_POLICY = (
    {
        "sleep_before_action": 0,  # min
        "default_action": rm_const.RestartPolicyActions.NOOP,
    },
)

# Per project settings
# Librarian
LIBRARIAN_ENVS = {
    rm_const.ReleaseStatus.testing: [
        "alet.librarian-api.testing",
        "alet.librarian-bazinga-binder.testing",
        "alet.librarian-bazinga-extimport.testing",
        "alet.librarian-cms.testing",
        "alet.librarian-idm.testing",
        "alet.librarian-worker.testing",
        "alet.librarian-yaga.testing"
    ],
    rm_const.ReleaseStatus.stable: [
        "alet.librarian-api.production",
        "alet.librarian-bazinga-binder.production",
        "alet.librarian-bazinga-extimport.production",
        "alet.librarian-cms.production",
        "alet.librarian-idm.production",
        "alet.librarian-worker.production",
        "alet.librarian-yaga.production"
    ]
}

# Widget backend
WIDGET_BACKEND_ENVS = {
    rm_const.ReleaseStatus.testing: [
        "afisha-tickets.api.testing",
        "afisha-tickets.api.load",
        "afisha-tickets.worker.testing",
        "afisha-tickets.worker.load",
        "afisha-tickets.workercritical.testing",
        "afisha-tickets.cms.testing",
        "afisha-tickets.bazingamaster.testing",
        "afisha-tickets.bazingamaster.load"
    ],
    rm_const.ReleaseStatus.stable: [
        "afisha-tickets.api.production",
        "afisha-tickets.worker.production",
        "afisha-tickets.workercritical.production",
        "afisha-tickets.cms.production",
        "afisha-tickets.bazingamaster.production"
    ]
}

# Ticketsystem backend
TICKETSYSTEM_BACKEND_ENVS = {
    rm_const.ReleaseStatus.testing: [
        "afisha-ticketsystem.bazinga.testing"
    ],
    rm_const.ReleaseStatus.stable: [
        "afisha-ticketsystem.bazinga.production"
    ]
}

IMPORTANT_CHANGES_LIMIT = 1000
