# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects.common.apihelpers import get_task_resource_id
from sandbox.projects import resource_types
from sandbox.projects.common.environments import (SandboxJavaJdkEnvironment, AllureCommandLineEnvironment)


class AllureReportTask(SandboxTask):
    type = 'ALLURE_REPORT_TASK'

    cores = 1

    class TasksToGenerate(SandboxStringParameter):
        name = 'tasks_to_generate'
        description = 'Comma separated list of tasks ids to generate Allure report'
        default_value = ""

    input_parameters = [
        TasksToGenerate
    ]

    environment = [
        SandboxJavaJdkEnvironment('1.8.0'),
        AllureCommandLineEnvironment('1.4.19'),
    ]

    def on_execute(self):
        self.ctx['subtask_ids'] = self.ctx[self.TasksToGenerate.name].split(",")

        dirs = []
        for task_id in self.ctx['subtask_ids']:
            path = self.sync_resource(get_task_resource_id(task_id, resource_types.ALLURE_RESULTS))
            dirs.append(path)

        launches = " ".join(dirs)
        run_process(['allure', 'generate', launches], log_prefix='allure-log')

        self.create_resource(
            self.descr,
            'allure-report',
            resource_types.ALLURE_REPORT,
            arch='any',
            attributes={"ttl": "7"}
        )

        pass


__Task__ = AllureReportTask
