# coding=utf-8

import re
import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters


# import collections


class Task(sdk_task.SandboxTask):
    """ A task, which enumerates comments ad FML-2575. """

    class TokenName(sdk_parameters.SandboxStringParameter):
        name = "startrack_token"
        description = "Vault with startrack Token"

    type = "ANNOTATE_FML_2575_COMMENTS"
    input_parameters = [TokenName]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import startrack_api
        import get_file_strategy
        import get_file

        # sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/nirvana_tools/workflow_dump_to_json"))
        # import workflow_dump_to_json

        st_token = self.get_vault_data(self.ctx[self.TokenName.name])

        task_id_re = re.compile('%%FML-2575-ID_(\d+)%%')

        comment_helper = startrack_api.Comments('FML-2575', st_token, get_file_strategy=get_file_strategy.return_get_file_class(get_file.GetFile))

        comments = comment_helper.GetAllComments()

        for n_commnet, comment in enumerate(comments, 1):
            text = dict(comment)['text']
            ya_packag_task_id = re.findall(task_id_re, text)
            if not len(ya_packag_task_id):
                new_id = "%%FML-2575-ID_{0}%%\n".format(str(n_commnet).zfill(4))
                comment_id = dict(comment)['id']
                comment_helper.UPDATE(new_id + text, comment_id)
                logging.info(n_commnet)


__Task__ = Task
