import logging
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.ApikeysB2bgeo import B2BGEO_APIKEYS_STAT_BIN as BIN

# RESOURCE_OWNERS = ['B2BGEO', 'dante', 'tuxxon']


class PushApikeysStat(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    def on_execute(self):

        # define YT token
        token = sdk2.Vault.data('robot_b2bgeo_yt_token')
        os.environ['YT_TOKEN'] = token

        # set env variable
        os.environ['APIKEYS_ENV'] = 'production'

        # find binary
        binary_resource = sdk2.Resource.find(
            resource_type=BIN,
            # owner=RESOURCE_OWNERS,
        ).order(-sdk2.Resource.id).first()
        binary_path = str(sdk2.ResourceData(binary_resource).path)
        logging.info('Binary path: %s' % binary_path)

        # run binary
        command_line = [binary_path]
        with sdk2.helpers.ProcessLog(self, logger="push_stats") as pl:
            sp.check_call(command_line, stdout=pl.stdout, stderr=sp.STDOUT)
