from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import datetime


class ApikeysVrpGit(sdk2.Task):

    class Requirements(sdk2.Requirements):
        privileged = True

    class Parameters(sdk2.Task.Parameters):
        apikeys_env = sdk2.parameters.String('Apikeys environment, production or testing', default_value='production')
        debug_run = sdk2.parameters.Bool('Run with only part of apikeys. Will only work in testing environment',
                                         default_value=False)

    def on_execute(self):
        statbox_token = sdk2.Vault.data('robot_b2bgeo_statbox_token')
        geocoder_token = sdk2.Vault.data('robot_b2bgeo_geocoder_token')
        yesterday = (datetime.datetime.now() - datetime.timedelta(days=1)).strftime('%Y-%m-%d')
        venv_postfix = datetime.datetime.now().strftime('%y-%m-%d-%H-%M')

        apikeys_env = self.Parameters.apikeys_env
        debug_run = self.Parameters.debug_run

        if debug_run and apikeys_env == 'production':
            raise ValueError('debug run not allowed in production')

        debug_run_flag = '--debug_run' if debug_run else ''

        commands = [
            'sudo apt-get update',
            'sudo apt-get install build-essential libpq-dev libssl-dev openssl libffi-dev zlib1g-dev --yes',
            'sudo apt-get install python3.7 --yes',
            'ln -s /opt/python3.7/bin/python3.7 /usr/bin/python3.7',
            'python3.7 -m venv venv_{}'.format(venv_postfix),
            '. venv_{}/bin/activate'.format(venv_postfix),
            'pip3 install --upgrade pip',
            'pip3 install --upgrade setuptools',
            'pip3 install wheel',
            'pip3 install ipykernel',
            'pip3 install -i https://pypi.yandex-team.ru/simple -U git+https://github.yandex-team.ru/B2BGeo/tools',
            'mkdir ~/.statbox',
            'echo "---" > ~/.statbox/statface_auth.yaml',
            'echo "oauth_token: {}" >> ~/.statbox/statface_auth.yaml'.format(statbox_token),
            'export GEOCODER_TOKEN="{}"'.format(geocoder_token),
            'pip3 install -i https://pypi.yandex-team.ru/simple --no-deps --disable-pip-version-check --force-reinstall --upgrade certifi-yandex',
            'billing --begin {} --end {} --only_without_depot --push_to_apikeys {} --apikeys_env {}'.format(yesterday, yesterday, debug_run_flag, apikeys_env)
        ]

        with sdk2.helpers.ProcessLog(self, logger="script-log") as pl:
            sp.check_output("; ".join(commands), stderr=pl.stderr, shell=True)
