import os

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process
from sandbox.projects import resource_types
import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk as arcadia_sdk


class LazyPaths(object):
    arcadia_path = None
    arcadia_url = None

    @classmethod
    def get_arcadia_url(cls):
        return cls.arcadia_url

    @classmethod
    def set_arcadia_url(cls, arcadia_url):
        cls.arcadia_url = arcadia_url

    @classmethod
    def get_python_path(cls):
        return os.path.join(os.sep, 'skynet', 'python', 'bin', 'python')


class DirGraphTask(SandboxTask):
    type = 'AUTOCHECK_DIR_GRAPH_TASK'

    cores = 1
    required_ram = 65536
    execution_space = 10 * 1024

    input_parameters = [build_params.ArcadiaUrl, ]

    client_tags = ctc.Tag.Group.LINUX

    def ya_dump_json(self, path, *opts):
        with arcadia_sdk.mount_arc_path(LazyPaths.get_arcadia_url(), use_arc_instead_of_aapi=True) as arcadia_path:
            cmd = [LazyPaths.get_python_path(), os.path.join(arcadia_path, 'ya'), '-v', 'dump'] + list(opts)
            run_process(cmd, check=True, work_dir=arcadia_path, outputs_to_one_file=False, stdout=open(path, 'w'), stderr=open(self.log_path('ya.log'), 'a'))
            return path

    def on_execute(self):
        LazyPaths.set_arcadia_url(self.ctx[consts.ARCADIA_URL_KEY])
        revision = LazyPaths.get_arcadia_url().split('@')[-1]

        arcadia_dir_graph_path = self.ya_dump_json(self.abs_path('arcadia_dir_graph.json'), 'dir-graph', '-t', '--split', 'autocheck')

        self.create_resource(
            'arcadia_dir_graph',
            resource_path=arcadia_dir_graph_path,
            resource_type=resource_types.ARCADIA_DIR_GRAPH,
            attributes={'revision': revision}
        )


__Task__ = DirGraphTask
